/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.structure;

import com.mrdimka.hammercore.structure.Structure;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableManager;

public class StructureAPI {
    private static final Set<String> allStructures = new HashSet<String>();

    public static Structure Export(World world, BlockPos start, BlockPos end, boolean includeAir) {
        Structure s = new Structure();
        for (int x = Math.min(start.func_177958_n(), end.func_177958_n()); x <= Math.max(start.func_177958_n(), end.func_177958_n()); ++x) {
            for (int y = Math.min(start.func_177956_o(), end.func_177956_o()); y <= Math.max(start.func_177956_o(), end.func_177956_o()); ++y) {
                for (int z = Math.min(start.func_177952_p(), end.func_177952_p()); z <= Math.max(start.func_177952_p(), end.func_177952_p()); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (world.func_175623_d(pos) && !includeAir) continue;
                    BlockPos absPos = new BlockPos(x - Math.min(start.func_177958_n(), end.func_177958_n()), y - Math.min(start.func_177956_o(), end.func_177956_o()), z - Math.min(start.func_177952_p(), end.func_177952_p()));
                    s.placeStateAt(absPos, world.func_180495_p(pos));
                    if (world.func_175625_s(pos) == null) continue;
                    NBTTagCompound nbt = world.func_175625_s(pos).serializeNBT();
                    nbt.func_82580_o("x");
                    nbt.func_82580_o("y");
                    nbt.func_82580_o("z");
                    s.placeTileNBTAt(absPos, nbt);
                }
            }
        }
        return s;
    }

    public static void Import(World world, BlockPos startPos, Structure structure) {
        structure.build(world, startPos);
    }

    public static boolean IsValid(World world, BlockPos centerPos, Structure structure) {
        BlockPos tpos;
        for (Long pl : structure.stateMap.keySet()) {
            tpos = BlockPos.func_177969_a((long)pl);
            if (!world.func_175667_e(tpos)) {
                world.func_175726_f(tpos);
            }
            IBlockState src = structure.getStateAt(tpos);
            IBlockState state = world.func_180495_p(tpos.func_177971_a((Vec3i)centerPos));
            if (state.func_177230_c() == src.func_177230_c() && state.func_177230_c().func_176201_c(src) == state.func_177230_c().func_176201_c(state)) continue;
            return false;
        }
        for (Long pl : structure.tileMap.keySet()) {
            tpos = BlockPos.func_177969_a((long)pl);
            if (!world.func_175667_e(tpos)) {
                world.func_175726_f(tpos);
            }
            TileEntity te = world.func_175625_s(tpos.func_177971_a((Vec3i)centerPos));
            NBTTagCompound src = structure.getTileNBTAt(tpos);
            NBTTagCompound nbt = te.serializeNBT();
            NBTTagCompound merged = nbt.func_74737_b();
            merged.func_179237_a(src);
            if (nbt.equals((Object)merged)) continue;
            return false;
        }
        return true;
    }

    public static void Save(Structure s, OutputStream os) throws IOException {
        CompressedStreamTools.func_74799_a((NBTTagCompound)s.serialize(), (OutputStream)os);
    }

    public static Structure Parse(Scanner in) throws IOException {
        Structure struct = new Structure();
        in.nextLine();
        int line = 0;
        while (in.hasNextLine()) {
            ++line;
            String ln = in.nextLine().replaceAll("\r", "");
            if (ln.startsWith("#") || ln.trim().isEmpty()) continue;
            try {
                int[] zs;
                int[] ys;
                int[] xs;
                String[] pos;
                if (ln.startsWith("{block}.{")) {
                    pos = (ln = ln.substring(9)).substring(0, ln.indexOf("}")).split(",");
                    if (pos.length != 3) {
                        throw new IOException("Failed to parse position at line #" + line + "!");
                    }
                    xs = StructureAPI.From(pos[0]);
                    ys = StructureAPI.From(pos[1]);
                    zs = StructureAPI.From(pos[2]);
                    String state = ln.substring(ln.indexOf("}.") + 2);
                    int meta = Integer.parseInt(state.substring(0, state.indexOf(46)));
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(state.substring(state.indexOf(46) + 1)));
                    int[] nArray = xs;
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        int x = nArray[i];
                        int[] nArray2 = ys;
                        int n2 = nArray2.length;
                        for (int j = 0; j < n2; ++j) {
                            int y = nArray2[j];
                            int[] nArray3 = zs;
                            int n3 = nArray3.length;
                            for (int k = 0; k < n3; ++k) {
                                int z = nArray3[k];
                                struct.placeStateAt(new BlockPos(x, y, z), block.func_176203_a(meta));
                            }
                        }
                    }
                    continue;
                }
                if (ln.startsWith("{tile}.{")) {
                    pos = (ln = ln.substring(8)).substring(0, ln.indexOf("}")).split(",");
                    if (pos.length != 3) {
                        throw new IOException("Failed to parse position at line #" + line + "!");
                    }
                    xs = StructureAPI.From(pos[0]);
                    ys = StructureAPI.From(pos[1]);
                    zs = StructureAPI.From(pos[2]);
                    String nbtStr = ln.substring(ln.indexOf("}.") + 2);
                    NBTTagCompound nbt = JsonToNBT.func_180713_a((String)nbtStr);
                    for (int x : xs) {
                        for (int y : ys) {
                            for (int z : zs) {
                                struct.placeTileNBTAt(new BlockPos(x, y, z), nbt);
                            }
                        }
                    }
                    continue;
                }
                throw new IOException("Unable to read modifier! [" + ln + "]");
            }
            catch (Throwable err) {
                throw new IOException("Failed to parse line #" + line + ": " + err.getMessage(), err);
            }
        }
        return struct;
    }

    public static ResourceLocation registerSpawnableStructure(ResourceLocation resource) {
        allStructures.add(resource.toString());
        return resource;
    }

    public static Structure ParseBuiltin(ResourceLocation resource) throws IOException {
        URL url = LootTableManager.class.getResource("/assets/" + resource.func_110624_b() + "/structures/" + resource.func_110623_a() + ".hcstr");
        if (url != null) {
            Scanner s = new Scanner(url.openStream());
            Structure struct = StructureAPI.Parse(s);
            s.close();
            return struct;
        }
        return new Structure();
    }

    public static Set<String> GetAllStructures() {
        return allStructures;
    }

    private static int[] From(String str) {
        int b;
        if (!str.contains(" to ")) {
            return new int[]{Integer.parseInt(str)};
        }
        String[] ab = str.split(" to ");
        int a = Integer.parseInt(ab[0]);
        if (a > (b = Integer.parseInt(ab[1]))) {
            return new int[0];
        }
        int[] abs = new int[b - a + 1];
        for (int i = 0; i < abs.length; ++i) {
            abs[i] = a + i;
        }
        return abs;
    }

    public static Structure Load(InputStream in) throws IOException {
        Structure s = new Structure();
        s.deserialize(CompressedStreamTools.func_74796_a((InputStream)in));
        return s;
    }
}

