/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.tile;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.net.pkt.PacketSyncSyncableTile;
import com.mrdimka.hammercore.tile.TileSyncableTickable;
import com.pengu.hammercore.net.utils.IPropertyChangeHandler;
import com.pengu.hammercore.net.utils.NetPropertyAbstract;
import com.pengu.hammercore.utils.WorldLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileSyncable
extends TileEntity
implements IPropertyChangeHandler {
    protected World readNBT_world;
    private final List<NetPropertyAbstract> properties = new ArrayList<NetPropertyAbstract>();
    private NBTTagCompound lastSyncTag;
    protected WorldLocation loc;
    protected Random rand = new Random();
    public boolean escapeSyncIfIdentical = false;
    private IItemHandler[] itemHandlers;

    public TileSyncable() {
        this.initProperties();
        this.itemHandlers = new IItemHandler[6];
    }

    public WorldLocation getLocation() {
        if (this.loc == null || !this.loc.getPos().equals((Object)this.field_174879_c)) {
            this.loc = new WorldLocation(this.field_145850_b, this.field_174879_c);
        }
        return this.loc;
    }

    public void initProperties() {
    }

    public Random getRNG() {
        if (this.rand == null) {
            this.rand = new Random();
        }
        return this.rand;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sync();
    }

    public void sync() {
        this.getLocation();
        if (this.escapeSyncIfIdentical) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeNBT(nbt);
            if (this.lastSyncTag != null && this.lastSyncTag.equals((Object)nbt)) {
                return;
            }
            this.lastSyncTag = nbt;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            PacketSyncSyncableTile tile = new PacketSyncSyncableTile(this);
            HCNetwork.manager.sendToAllAround(tile, this.getSyncPoint(260));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NetworkRegistry.TargetPoint getSyncPoint(int range) {
        return new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)range);
    }

    public abstract void writeNBT(NBTTagCompound var1);

    public abstract void readNBT(NBTTagCompound var1);

    public final NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeNBT(tag);
        nbt.func_74782_a("Tags", (NBTBase)tag);
        if (this instanceof TileSyncableTickable) {
            nbt.func_74768_a("TicksExisted", ((TileSyncableTickable)this).ticksExisted);
        }
        NBTTagList props = new NBTTagList();
        for (NetPropertyAbstract prop : this.properties) {
            NBTTagCompound tag2 = new NBTTagCompound();
            prop.writeToNBT(tag2);
            tag2.func_74778_a("Class", prop.getClass().getName());
            tag2.func_74768_a("Id", this.properties.indexOf(prop));
            props.func_74742_a((NBTBase)tag2);
        }
        nbt.func_74782_a("Properties", (NBTBase)props);
        return nbt;
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        if (this.readNBT_world == null && this.field_145850_b != null) {
            this.readNBT_world = this.field_145850_b;
        }
        super.func_145839_a(nbt);
        if (!nbt.func_150297_b("Tags", 10)) {
            HammerCore.LOG.warn("TileEntity " + this + " tried to load old NBT Key: \"tags\". It is going to be renamed to \"Tags\"!", new Object[0]);
        }
        this.readNBT(!nbt.func_150297_b("Tags", 10) ? nbt.func_74775_l("tags") : nbt.func_74775_l("Tags"));
        if (this instanceof TileSyncableTickable) {
            ((TileSyncableTickable)this).ticksExisted = nbt.func_74762_e("TicksExisted");
        }
        NBTTagList props = nbt.func_150295_c("Properties", 10);
        for (int i = 0; i < props.func_74745_c(); ++i) {
            try {
                NBTTagCompound tag = props.func_150305_b(i);
                int id = tag.func_74762_e("Id");
                if (this.properties.size() <= id) continue;
                NetPropertyAbstract prop = this.properties.get(id);
                prop.readFromNBT(tag);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.readNBT_world = null;
    }

    protected void func_190201_b(World worldIn) {
        this.readNBT_world = worldIn;
    }

    protected IItemHandler createSidedHandler(EnumFacing side) {
        if (this instanceof ISidedInventory) {
            SidedInvWrapper sidedInvWrapper = new SidedInvWrapper((ISidedInventory)this, side);
            this.itemHandlers[side.ordinal()] = sidedInvWrapper;
            return sidedInvWrapper;
        }
        if (this instanceof IInventory) {
            InvWrapper invWrapper = new InvWrapper((IInventory)this);
            this.itemHandlers[side.ordinal()] = invWrapper;
            return invWrapper;
        }
        return null;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this instanceof IInventory) {
            return (T)(this.itemHandlers[facing.ordinal()] == null ? this.createSidedHandler(facing) : this.itemHandlers[facing.ordinal()]);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this instanceof IInventory || super.hasCapability(capability, facing);
    }

    public boolean atTickRate(int rate) {
        return (this.field_145850_b.func_82737_E() + this.field_174879_c.func_177986_g()) % (long)rate == 0L;
    }

    public final void tryOpenGui(EntityPlayer player, World world) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)HammerCore.instance, (int)0, (World)world, (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p());
        }
    }

    public void onPlacedBy(EntityPlayer player, EnumHand hand) {
    }

    public boolean hasGui() {
        return false;
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return null;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return null;
    }

    @Override
    public int registerProperty(NetPropertyAbstract prop) {
        if (this.properties.contains(prop)) {
            return this.properties.indexOf(prop);
        }
        this.properties.add(prop);
        return this.properties.size() - 1;
    }

    @Override
    public void load(int id, NBTTagCompound nbt) {
        if (id >= 0 && id < this.properties.size()) {
            this.properties.get(id).readFromNBT(nbt);
        }
    }

    @Override
    public void notifyOfChange(NetPropertyAbstract prop) {
    }

    @Override
    public void sendChangesToNearby() {
        this.sync();
    }

    @SideOnly(value=Side.CLIENT)
    public void addProperties(Map<String, Object> properties, RayTraceResult trace) {
    }
}

