/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.world.gen;

import com.google.common.base.Predicates;
import com.mrdimka.hammercore.world.gen.IWorldGenFeature;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenFeatureOre
implements IWorldGenFeature {
    public int minY = 0;
    public int maxY = 64;
    public int maxClusters = 6;
    public int maxCusterSize = 8;
    public boolean enableBiomeWhitelist = false;
    public boolean enableDimensionWhitelist = false;
    public final IBlockState oreState;
    public IBlockState sourceState = Blocks.field_150348_b.func_176223_P();
    public final Set<Integer> dimensionWhitelist = new HashSet<Integer>();
    public final Set<Biome> biomes = new HashSet<Biome>();

    public WorldGenFeatureOre(IBlockState ore) {
        this.oreState = ore;
    }

    @Override
    public int getMaxChances(World world, ChunkPos chunk, Random rand) {
        return this.maxClusters;
    }

    @Override
    public int getMinY(World world, BlockPos pos, Random rand) {
        return this.minY;
    }

    @Override
    public int getMaxY(World world, BlockPos pos, Random rand) {
        return this.maxY;
    }

    @Override
    public void generate(World world, BlockPos pos, Random rand) {
        boolean biomeMatches;
        boolean dimMatches;
        boolean bl = dimMatches = !this.enableDimensionWhitelist;
        if (!dimMatches) {
            dimMatches = this.dimensionWhitelist.contains(world.field_73011_w.getDimension());
        }
        boolean bl2 = biomeMatches = !this.enableBiomeWhitelist;
        if (!biomeMatches) {
            biomeMatches = this.biomes.contains(world.func_180494_b(pos));
        }
        if (biomeMatches && dimMatches) {
            new WorldGenMinable(this.oreState, this.maxCusterSize, Predicates.equalTo((Object)this.sourceState)).func_180709_b(world, rand, pos);
        }
    }
}

