/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.client.model.simple;

import com.pengu.hammercore.client.model.simple.SimpleModelParser;
import com.pengu.hammercore.client.render.vertex.SimpleBlockRendering;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;

public class OpnodeRender {
    public static void renderOpnodes(SimpleBlockRendering sbr, List<int[]> nodes, int bright, boolean newTessellation) {
        if (newTessellation) {
            sbr.begin();
        }
        for (int[] node : nodes) {
            OpnodeRender.renderOpnode(sbr, node, bright, false);
        }
        if (newTessellation) {
            sbr.end();
        }
    }

    public static void renderOpnode(SimpleBlockRendering sbr, int[] opnode, int bright, boolean newTessellation) {
        if (newTessellation) {
            sbr.begin();
        }
        sbr.setBrightness(bright);
        for (int i = 0; i < opnode.length; ++i) {
            int code = opnode[i];
            if (code == 0) {
                EnumFacing f = EnumFacing.field_82609_l[opnode[++i]];
                sbr.disableFace(f);
                continue;
            }
            if (code == 1) {
                EnumFacing f = EnumFacing.field_82609_l[opnode[++i]];
                sbr.enableFace(f);
                continue;
            }
            if (code == 2) {
                int r = opnode[++i];
                int g = opnode[++i];
                int b = opnode[++i];
                int a = opnode[++i];
                Arrays.fill(sbr.rgb, r >> 16 | g >> 8 | b);
                sbr.rb.renderAlpha = (float)a / 255.0f;
                continue;
            }
            if (code == 3) {
                double m1 = SimpleModelParser.getDouble(opnode, i + 1);
                double m2 = SimpleModelParser.getDouble(opnode, i + 3);
                double m3 = SimpleModelParser.getDouble(opnode, i + 5);
                double m4 = SimpleModelParser.getDouble(opnode, i + 7);
                double m5 = SimpleModelParser.getDouble(opnode, i + 9);
                double m6 = SimpleModelParser.getDouble(opnode, i + 11);
                sbr.setRenderBounds(m1, m2, m3, m4, m5, m6);
                i += 12;
                continue;
            }
            if (code == 6) {
                sbr.enableFaces();
                continue;
            }
            if (code == 5) {
                sbr.disableFaces();
                continue;
            }
            if (code == 4) {
                sbr.drawBlock(0.0, 0.0, 0.0);
                continue;
            }
            if (code == 8) {
                ++i;
                i += opnode[i];
                continue;
            }
            if (code != 7) continue;
            int len = opnode[++i];
            int face = opnode[++i];
            ++i;
            byte[] buf = new byte[len];
            for (int j = 0; j < len; ++j) {
                buf[j] = (byte)opnode[i + j];
            }
            i += len - 1;
            sbr.setSpriteForSide(EnumFacing.field_82609_l[face], Minecraft.func_71410_x().func_147117_R().func_110572_b(new String(buf)));
        }
        if (newTessellation) {
            sbr.end();
        }
        Arrays.fill(sbr.rgb, 0xFFFFFF);
        sbr.rb.renderAlpha = 1.0f;
    }
}

