/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.client.particle.def;

import com.mrdimka.hammercore.api.IUpdatable;
import com.mrdimka.hammercore.vec.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class LightningBoltCommon
implements IUpdatable {
    ArrayList<Segment> segments = new ArrayList();
    Vector3 start;
    Vector3 end;
    HashMap splitparents = new HashMap();
    public float multiplier;
    public float length;
    public int numsegments0;
    public int increment;
    public int type = 0;
    public boolean nonLethal = false;
    private int numsplits;
    private boolean finalized;
    private boolean canhittarget = true;
    private Random rand;
    public long seed;
    public int particleAge;
    public int particleMaxAge;
    private AxisAlignedBB boundingBox;
    private World world;
    public EntityLivingBase wrapper;
    public static final float speed = 3.0f;
    public static final int fadetime = 20;
    public static int damage;
    boolean spawned = false;

    public LightningBoltCommon(World world, Vector3 jammervec, Vector3 targetvec, long seed) {
        this.world = world;
        this.start = jammervec;
        this.end = targetvec;
        this.seed = seed;
        this.rand = new Random(seed);
        this.numsegments0 = 1;
        this.increment = 1;
        this.length = this.end.copy().sub(this.start).length();
        this.particleMaxAge = 3 + this.rand.nextInt(3) - 1;
        this.multiplier = 1.0f;
        this.particleAge = -((int)(this.length * 3.0f));
        this.boundingBox = new AxisAlignedBB(Math.min(this.start.x, this.end.x), Math.min(this.start.y, this.end.y), Math.min(this.start.z, this.end.z), Math.max(this.start.x, this.end.x), Math.max(this.start.y, this.end.y), Math.max(this.start.z, this.end.z)).func_72321_a((double)(this.length / 2.0f), (double)(this.length / 2.0f), (double)(this.length / 2.0f));
        this.segments.add(new Segment(this.start, this.end));
    }

    public LightningBoltCommon(World world, Entity detonator, Entity target, long seed) {
        this(world, new Vector3(detonator), new Vector3(target), seed);
    }

    public LightningBoltCommon(World world, Entity detonator, Entity target, long seed, int speed) {
        this(world, new Vector3(detonator), new Vector3(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e() - (double)0.7f, target.field_70161_v), seed);
        this.increment = speed;
        this.multiplier = 0.4f;
    }

    public LightningBoltCommon(World world, TileEntity detonator, Entity target, long seed) {
        this(world, new Vector3(detonator), new Vector3(target), seed);
    }

    public LightningBoltCommon(World world, TileEntity detonator, double x, double y, double z, long seed) {
        this(world, new Vector3(detonator), new Vector3(x, y, z), seed);
    }

    public LightningBoltCommon(World world, double x1, double y1, double z1, double x, double y, double z, long seed, int duration, float multi) {
        this(world, new Vector3(x1, y1, z1), new Vector3(x, y, z), seed);
        this.particleMaxAge = duration + this.rand.nextInt(duration) - duration / 2;
        this.multiplier = multi;
    }

    public LightningBoltCommon(World world, double x1, double y1, double z1, double x, double y, double z, long seed, int duration, float multi, int speed) {
        this(world, new Vector3(x1, y1, z1), new Vector3(x, y, z), seed);
        this.particleMaxAge = duration + this.rand.nextInt(duration) - duration / 2;
        this.multiplier = multi;
        this.increment = speed;
    }

    public void setWrapper(EntityLivingBase entity) {
        this.wrapper = entity;
    }

    public void setMultiplier(float m) {
        this.multiplier = m;
    }

    public void fractal(int splits, float amount, float splitchance, float splitlength, float splitangle) {
        if (this.finalized) {
            return;
        }
        ArrayList<Segment> oldsegments = this.segments;
        this.segments = new ArrayList();
        Segment prev = null;
        for (Segment segment : oldsegments) {
            int i;
            prev = segment.prev;
            Vector3 subsegment = segment.diff.copy().scale(1.0f / (float)splits);
            BoltPoint[] newpoints = new BoltPoint[splits + 1];
            Vector3 startpoint = segment.startpoint.point;
            newpoints[0] = segment.startpoint;
            newpoints[splits] = segment.endpoint;
            for (i = 1; i < splits; ++i) {
                Vector3 randoff = Vector3.getPerpendicular(segment.diff).rotate(this.rand.nextFloat() * 360.0f, segment.diff);
                randoff.scale((this.rand.nextFloat() - 0.5f) * amount);
                Vector3 basepoint = startpoint.copy().add(subsegment.copy().scale(i));
                newpoints[i] = new BoltPoint(basepoint, randoff);
            }
            for (i = 0; i < splits; ++i) {
                Segment next = new Segment(newpoints[i], newpoints[i + 1], segment.light, segment.segmentno * splits + i, segment.splitno);
                next.prev = prev;
                if (prev != null) {
                    prev.next = next;
                }
                if (i != 0 && this.rand.nextFloat() < splitchance) {
                    Vector3 splitrot = Vector3.xCrossProduct(next.diff).rotate(this.rand.nextFloat() * 360.0f, next.diff);
                    Vector3 diff = next.diff.copy().rotate((this.rand.nextFloat() * 0.66f + 0.33f) * splitangle, splitrot).scale(splitlength);
                    ++this.numsplits;
                    this.splitparents.put(this.numsplits, next.splitno);
                    Segment split = new Segment(newpoints[i], new BoltPoint(newpoints[i + 1].basepoint, newpoints[i + 1].offsetvec.copy().add(diff)), segment.light / 2.0f, next.segmentno, this.numsplits);
                    split.prev = prev;
                    this.segments.add(split);
                }
                prev = next;
                this.segments.add(next);
            }
            if (segment.next == null) continue;
            segment.next.prev = prev;
        }
        this.numsegments0 *= splits;
    }

    public void defaultFractal() {
        this.fractal(2, this.length * this.multiplier / 8.0f, 0.7f, 0.1f, 45.0f);
        this.fractal(2, this.length * this.multiplier / 12.0f, 0.5f, 0.1f, 50.0f);
        this.fractal(2, this.length * this.multiplier / 17.0f, 0.5f, 0.1f, 55.0f);
        this.fractal(2, this.length * this.multiplier / 23.0f, 0.5f, 0.1f, 60.0f);
        this.fractal(2, this.length * this.multiplier / 30.0f, 0.0f, 0.0f, 0.0f);
        this.fractal(2, this.length * this.multiplier / 34.0f, 0.0f, 0.0f, 0.0f);
        this.fractal(2, this.length * this.multiplier / 40.0f, 0.0f, 0.0f, 0.0f);
    }

    private void vecBBDamageSegment(Vector3 start, Vector3 end, ArrayList<Entity> entitylist) {
        Vec3d start3D = start.toVec3d();
        Vec3d end3D = end.toVec3d();
        try {
            for (Entity entity : entitylist) {
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                if (!(entity instanceof EntityLiving) || !axisalignedbb.func_72318_a(start3D)) continue;
                if (this.wrapper == null || !(this.wrapper instanceof EntityLiving)) {
                    switch (this.type) {
                        case 0: {
                            entity.func_70097_a(DamageSource.field_76376_m, (float)damage);
                            this.poisonBolt(entity, MobEffects.field_76431_k, 2);
                            break;
                        }
                        case 1: {
                            entity.func_70097_a(DamageSource.field_76376_m, (float)damage);
                            break;
                        }
                        case 2: {
                            entity.func_70097_a(DamageSource.field_76376_m, (float)damage);
                            this.poisonBolt(entity, MobEffects.field_76421_d, 2);
                            break;
                        }
                        case 3: {
                            entity.func_70097_a(DamageSource.field_76376_m, (float)damage);
                            this.poisonBolt(entity, MobEffects.field_76436_u, 1);
                            break;
                        }
                        case 4: {
                            entity.func_70097_a(DamageSource.field_76376_m, (float)damage);
                            entity.func_70015_d(2);
                            break;
                        }
                        case 5: {
                            entity.func_70097_a(DamageSource.field_76376_m, (float)damage);
                            this.poisonBolt(entity, MobEffects.field_76440_q, 1);
                        }
                    }
                    continue;
                }
                switch (this.type) {
                    case 0: {
                        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.wrapper), (float)damage);
                        this.poisonBolt(entity, MobEffects.field_76431_k, 2);
                        break;
                    }
                    case 1: {
                        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.wrapper), (float)damage);
                        break;
                    }
                    case 2: {
                        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.wrapper), (float)damage);
                        this.poisonBolt(entity, MobEffects.field_76421_d, 2);
                        break;
                    }
                    case 3: {
                        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.wrapper), (float)damage);
                        this.poisonBolt(entity, MobEffects.field_76436_u, 1);
                        break;
                    }
                    case 4: {
                        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.wrapper), (float)damage);
                        entity.func_70015_d(2);
                        break;
                    }
                    case 5: {
                        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.wrapper), (float)damage);
                        this.poisonBolt(entity, MobEffects.field_76440_q, 1);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void poisonBolt(Entity entity, Potion poison, int durmod) {
        int byte0 = 0;
        if (this.world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            if (this.world.func_175659_aa() == EnumDifficulty.EASY) {
                byte0 = 1;
            } else if (this.world.func_175659_aa() == EnumDifficulty.NORMAL) {
                byte0 = 3;
            } else if (this.world.func_175659_aa() == EnumDifficulty.HARD) {
                byte0 = 6;
            }
        }
        if (byte0 > 0 && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(poison, byte0 * 20 * durmod, 0));
        }
    }

    private void bbTestEntityDamage() {
        if (this.nonLethal) {
            return;
        }
        List nearentities = this.world.func_72872_a(Entity.class, this.boundingBox);
        if (nearentities.size() == 0) {
            return;
        }
        for (Segment segment : this.segments) {
            this.vecBBDamageSegment(segment.startpoint.point, segment.endpoint.point, (ArrayList)nearentities);
        }
    }

    private float rayTraceResistance(Vector3 start, Vector3 end, float prevresistance) {
        RayTraceResult mop = this.world.func_72933_a(start.toVec3d(), end.toVec3d());
        if (mop == null) {
            return prevresistance;
        }
        if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = this.world.func_180495_p(mop.func_178782_a());
            return prevresistance + state.func_185887_b(this.world, mop.func_178782_a());
        }
        return prevresistance;
    }

    private void calculateCollisionAndDiffs() {
        HashMap<Integer, Integer> lastactivesegment = new HashMap<Integer, Integer>();
        Collections.sort(this.segments, new SegmentSorter());
        int lastsplitcalc = 0;
        int lastactiveseg = 0;
        float splitresistance = 0.0f;
        for (Segment segment : this.segments) {
            if (segment.splitno > lastsplitcalc) {
                lastactivesegment.put(lastsplitcalc, lastactiveseg);
                lastsplitcalc = segment.splitno;
                lastactiveseg = (Integer)lastactivesegment.get(this.splitparents.get(segment.splitno));
                splitresistance = lastactiveseg >= segment.segmentno ? 0.0f : 50.0f;
                float f = splitresistance;
            }
            if (splitresistance >= 40.0f * segment.light) continue;
            lastactiveseg = segment.segmentno;
        }
        lastactivesegment.put(lastsplitcalc, lastactiveseg);
        lastsplitcalc = 0;
        lastactiveseg = (Integer)lastactivesegment.get(0);
        Iterator<Segment> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            Segment segment2 = iterator.next();
            if (lastsplitcalc != segment2.splitno) {
                lastsplitcalc = segment2.splitno;
                lastactiveseg = (Integer)lastactivesegment.get(segment2.splitno);
            }
            if (segment2.segmentno > lastactiveseg) {
                iterator.remove();
            }
            segment2.calcEndDiffs();
        }
        if ((Integer)lastactivesegment.get(0) + 1 < this.numsegments0) {
            this.canhittarget = false;
        }
    }

    public void finalizeBolt() {
        if (this.finalized) {
            return;
        }
        this.finalized = true;
        this.calculateCollisionAndDiffs();
        Collections.sort(this.segments, new SegmentLightSorter());
    }

    public void onUpdate() {
        this.particleAge += this.increment;
        if (this.particleAge > this.particleMaxAge) {
            this.particleAge = this.particleMaxAge;
        }
        this.bbTestEntityDamage();
    }

    @Override
    public void update() {
        this.onUpdate();
        if (!this.spawned) {
            this.spawned = true;
        }
    }

    @Override
    public boolean isAlive() {
        return this.particleAge < this.particleMaxAge;
    }

    public class BoltPoint {
        Vector3 point;
        Vector3 basepoint;
        Vector3 offsetvec;
        final LightningBoltCommon this$0;

        public BoltPoint(Vector3 basepoint, Vector3 offsetvec) {
            this.this$0 = LightningBoltCommon.this;
            this.point = basepoint.copy().add(offsetvec);
            this.basepoint = basepoint;
            this.offsetvec = offsetvec;
        }
    }

    public class Segment {
        public BoltPoint startpoint;
        public BoltPoint endpoint;
        public Vector3 diff;
        public Segment prev;
        public Segment next;
        public Vector3 nextdiff;
        public Vector3 prevdiff;
        public float sinprev;
        public float sinnext;
        public float light;
        public int segmentno;
        public int splitno;
        final LightningBoltCommon this$0;

        public void calcDiff() {
            this.diff = this.endpoint.point.copy().sub(this.startpoint.point);
        }

        public void calcEndDiffs() {
            Vector3 thisdiffnorm;
            if (this.prev != null) {
                Vector3 prevdiffnorm = this.prev.diff.copy().normalize();
                thisdiffnorm = this.diff.copy().normalize();
                this.prevdiff = thisdiffnorm.add(prevdiffnorm).normalize();
                this.sinprev = (float)Math.sin(Vector3.anglePreNorm(thisdiffnorm, prevdiffnorm.scale(-1.0f)) / 2.0f);
            } else {
                this.prevdiff = this.diff.copy().normalize();
                this.sinprev = 1.0f;
            }
            if (this.next != null) {
                Vector3 nextdiffnorm = this.next.diff.copy().normalize();
                thisdiffnorm = this.diff.copy().normalize();
                this.nextdiff = thisdiffnorm.add(nextdiffnorm).normalize();
                this.sinnext = (float)Math.sin(Vector3.anglePreNorm(thisdiffnorm, nextdiffnorm.scale(-1.0f)) / 2.0f);
            } else {
                this.nextdiff = this.diff.copy().normalize();
                this.sinnext = 1.0f;
            }
        }

        public String toString() {
            return String.valueOf(this.startpoint.point.toString()) + " " + this.endpoint.point.toString();
        }

        public Segment(BoltPoint start, BoltPoint end, float light, int segmentnumber, int splitnumber) {
            this.this$0 = LightningBoltCommon.this;
            this.startpoint = start;
            this.endpoint = end;
            this.light = light;
            this.segmentno = segmentnumber;
            this.splitno = splitnumber;
            this.calcDiff();
        }

        public Segment(Vector3 start, Vector3 end) {
            this(this$0.new BoltPoint(start, new Vector3(0.0, 0.0, 0.0)), this$0.new BoltPoint(end, new Vector3(0.0, 0.0, 0.0)), 1.0f, 0, 0);
        }
    }

    public class SegmentLightSorter
    implements Comparator {
        final LightningBoltCommon this$0;

        public int compare(Segment o1, Segment o2) {
            return Float.compare(o2.light, o1.light);
        }

        public int compare(Object obj, Object obj1) {
            return this.compare((Segment)obj, (Segment)obj1);
        }

        public SegmentLightSorter() {
            this.this$0 = LightningBoltCommon.this;
        }
    }

    public class SegmentSorter
    implements Comparator {
        final LightningBoltCommon this$0;

        public int compare(Segment o1, Segment o2) {
            int comp = Integer.valueOf(o1.splitno).compareTo(o2.splitno);
            if (comp == 0) {
                return Integer.valueOf(o1.segmentno).compareTo(o2.segmentno);
            }
            return comp;
        }

        public int compare(Object obj, Object obj1) {
            return this.compare((Segment)obj, (Segment)obj1);
        }

        public SegmentSorter() {
            this.this$0 = LightningBoltCommon.this;
        }
    }
}

