/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.client.render;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mrdimka.hammercore.client.utils.RenderUtil;
import com.pengu.hammercore.client.particle.api.ParticleList;
import com.pengu.hammercore.client.render.world.PositionRenderer;
import com.pengu.hammercore.color.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class Render3D {
    private static final String AUTHOR_USERNAME = "APengu";
    private static final String AUTHOR_DNAME = TextFormatting.BLUE + "" + TextFormatting.ITALIC + "       " + TextFormatting.RESET + "  ";
    public static int ticks = 0;
    private static final List<PositionRenderer> renders = new ArrayList<PositionRenderer>();
    private static final List<PositionRenderer> renderQueue = new ArrayList<PositionRenderer>();
    public static final Set<String> loadedPlayers = new HashSet<String>();
    public static int chatX = 0;
    public static int chatY = 0;

    public static void registerPositionRender(PositionRenderer render) {
        if (!renders.contains(render) && !renderQueue.contains(render)) {
            renderQueue.add(render);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderWorld(RenderWorldLastEvent evt) {
        while (!renderQueue.isEmpty()) {
            renders.add(renderQueue.remove(0));
        }
        for (int i = 0; i < renders.size(); ++i) {
            PositionRenderer render = renders.get(i);
            if (render.isDead()) {
                renders.remove(i);
                continue;
            }
            if (!render.canRender((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) continue;
            render.render((EntityPlayer)Minecraft.func_71410_x().field_71439_g, render.calcX(), render.calcY(), render.calcZ());
        }
        ParticleList.renderExtendedParticles(evt);
    }

    @SubscribeEvent
    public void renderLiving(RenderLivingEvent.Pre<EntityLivingBase> e) {
        if (!(e.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)e.getEntity();
    }

    @SubscribeEvent
    public void cpe(RenderGameOverlayEvent.Chat event) {
        chatX = event.getPosX();
        chatY = event.getPosY();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            ++ticks;
        }
    }

    @SubscribeEvent
    public void rne(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT) {
            GuiNewChat c = Minecraft.func_71410_x().field_71456_v.func_146158_b();
            List chatLines = c.field_146253_i;
            int updateCounter = Minecraft.func_71410_x().field_71456_v.field_73837_f;
            for (int i = 0; c.func_146241_e() && i < chatLines.size() || !c.func_146241_e() && i < chatLines.size() && i < 10; ++i) {
                ChatLine l = (ChatLine)chatLines.get(i);
                String s = l.func_151461_a().func_150260_c();
                for (int j = 0; j < s.length(); ++j) {
                    if (j >= s.length() - AUTHOR_DNAME.length() || !s.substring(j, j + AUTHOR_DNAME.length()).equals(AUTHOR_DNAME)) continue;
                    String before = s.substring(0, j);
                    float f = Minecraft.func_71410_x().field_71474_y.field_74357_r * 0.9f + 0.1f;
                    int j1 = updateCounter - l.func_74540_b();
                    if (j1 >= 200 && !c.func_146241_e()) continue;
                    double d0 = (double)j1 / 200.0;
                    d0 = 1.0 - d0;
                    d0 *= 10.0;
                    d0 = MathHelper.func_151237_a((double)d0, (double)0.0, (double)1.0);
                    d0 *= d0;
                    int l1 = (int)(255.0 * d0);
                    if (c.func_146241_e()) {
                        l1 = 255;
                    }
                    if (20 * (l1 = (int)((float)l1 * f)) / 255 <= 3) continue;
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    int dfunc = GL11.glGetInteger((int)2932);
                    GlStateManager.func_179143_c((int)515);
                    int func = GL11.glGetInteger((int)3009);
                    float ref = GL11.glGetFloat((int)3010);
                    GlStateManager.func_179092_a((int)519, (float)0.0f);
                    GlStateManager.func_179132_a((boolean)false);
                    GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
                    Render3D.drawTextGlowingAuraTransparent(Minecraft.func_71410_x().field_71466_p, AUTHOR_USERNAME, chatX + 2 + Minecraft.func_71410_x().field_71466_p.func_78256_a(before), chatY - Minecraft.func_71410_x().field_71466_p.field_78288_b * i, l1);
                    GL11.glTranslated((double)-0.25, (double)0.0, (double)0.0);
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179092_a((int)func, (float)ref);
                    GlStateManager.func_179143_c((int)dfunc);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                }
            }
        }
    }

    public static void drawTextGlowingAuraTransparent(FontRenderer font, String s, int x, int y, int a) {
        float sine = 0.5f * ((float)Math.sin(Math.toRadians((float)(4 * ticks) + Minecraft.func_71410_x().func_184121_ak())) + 1.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        int r = 16;
        int g = 16;
        int b = 175 + (int)(80.0f * sine);
        font.func_78276_b(s, x, y, Color.packARGB(r, g, b, a));
        RenderUtil.drawTextRGBA(font, s, x - 1, y, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 1, y, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y - 1, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y + 1, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x - 2, y, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 2, y, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y - 2, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y + 2, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x - 1, y + 1, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 1, y - 1, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x - 1, y - 1, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 1, y + 1, r, g, b, 20 * a / 255);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    private void setPlayerTexture(AbstractClientPlayer player, ResourceLocation texture) {
        NetworkPlayerInfo playerInfo = (NetworkPlayerInfo)ObfuscationReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)player, (int)0);
        if (playerInfo == null) {
            return;
        }
        Map playerTextures = (Map)ObfuscationReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (int)1);
        playerTextures.put(MinecraftProfileTexture.Type.SKIN, texture);
        if (texture == null) {
            ObfuscationReflectionHelper.setPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (Object)false, (int)4);
        }
    }
}

