/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.color;

import com.mrdimka.hammercore.common.utils.Copyable;
import com.mrdimka.hammercore.math.MathHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Color
implements Copyable<Color> {
    public byte r;
    public byte g;
    public byte b;
    public byte a;

    public Color(int r, int g, int b, int a) {
        this.r = (byte)r;
        this.g = (byte)g;
        this.b = (byte)b;
        this.a = (byte)a;
    }

    public Color(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
    }

    @SideOnly(value=Side.CLIENT)
    public void glColor() {
        GlStateManager.func_179131_c((float)((float)(this.r & 0xFF) / 255.0f), (float)((float)(this.g & 0xFF) / 255.0f), (float)((float)(this.b & 0xFF) / 255.0f), (float)((float)(this.a & 0xFF) / 255.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public void glColor(int a) {
        GlStateManager.func_179131_c((float)((float)(this.r & 0xFF) / 255.0f), (float)((float)(this.g & 0xFF) / 255.0f), (float)((float)(this.b & 0xFF) / 255.0f), (float)((float)a / 255.0f));
    }

    public abstract int pack();

    public abstract float[] packArray();

    public String toString() {
        return this.getClass().getSimpleName() + "[0x" + Integer.toHexString(this.pack()).toUpperCase() + "]";
    }

    public Color add(Color color2) {
        this.a = (byte)(this.a + color2.a);
        this.r = (byte)(this.r + color2.r);
        this.g = (byte)(this.g + color2.g);
        this.b = (byte)(this.b + color2.b);
        return this;
    }

    public Color sub(Color color2) {
        int ia = (this.a & 0xFF) - (color2.a & 0xFF);
        int ir = (this.r & 0xFF) - (color2.r & 0xFF);
        int ig = (this.g & 0xFF) - (color2.g & 0xFF);
        int ib = (this.b & 0xFF) - (color2.b & 0xFF);
        this.a = (byte)(ia < 0 ? 0 : ia);
        this.r = (byte)(ir < 0 ? 0 : ir);
        this.g = (byte)(ig < 0 ? 0 : ig);
        this.b = (byte)(ib < 0 ? 0 : ib);
        return this;
    }

    public Color invert() {
        this.a = (byte)(255 - (this.a & 0xFF));
        this.r = (byte)(255 - (this.r & 0xFF));
        this.g = (byte)(255 - (this.g & 0xFF));
        this.b = (byte)(255 - (this.b & 0xFF));
        return this;
    }

    public Color multiply(Color color2) {
        this.a = (byte)((double)(this.a & 0xFF) * ((double)(color2.a & 0xFF) / 255.0));
        this.r = (byte)((double)(this.r & 0xFF) * ((double)(color2.r & 0xFF) / 255.0));
        this.g = (byte)((double)(this.g & 0xFF) * ((double)(color2.g & 0xFF) / 255.0));
        this.b = (byte)((double)(this.b & 0xFF) * ((double)(color2.b & 0xFF) / 255.0));
        return this;
    }

    public Color scale(double d) {
        this.a = (byte)((double)(this.a & 0xFF) * d);
        this.r = (byte)((double)(this.r & 0xFF) * d);
        this.g = (byte)((double)(this.g & 0xFF) * d);
        this.b = (byte)((double)(this.b & 0xFF) * d);
        return this;
    }

    public Color interpolate(Color color2, double d) {
        return this.add(color2.copy().sub(this).scale(d));
    }

    public static int interpolateARGB(int ca, int cb, double d) {
        int a1 = ca >> 24 & 0xFF;
        int a2 = cb >> 24 & 0xFF;
        int r1 = ca >> 16 & 0xFF;
        int r2 = cb >> 16 & 0xFF;
        int g1 = ca >> 8 & 0xFF;
        int g2 = cb >> 8 & 0xFF;
        int b1 = ca >> 0 & 0xFF;
        int b2 = cb >> 0 & 0xFF;
        int inta = (int)((double)(a1 - a2) * d) + a1;
        int intr = (int)((double)(r1 - r2) * d) + r1;
        int intg = (int)((double)(g1 - g2) * d) + g1;
        int intb = (int)((double)(b1 - b2) * d) + b1;
        return Color.packARGB(intr, intg, intb, inta);
    }

    public static int interpolateRGBA(int ca, int cb, double d) {
        int r1 = ca >> 24 & 0xFF;
        int r2 = cb >> 24 & 0xFF;
        int g1 = ca >> 16 & 0xFF;
        int g2 = cb >> 16 & 0xFF;
        int b1 = ca >> 8 & 0xFF;
        int b2 = cb >> 8 & 0xFF;
        int a1 = ca >> 0 & 0xFF;
        int a2 = cb >> 0 & 0xFF;
        int inta = (int)((double)(a1 - a2) * d) + a1;
        int intr = (int)((double)(r1 - r2) * d) + r1;
        int intg = (int)((double)(g1 - g2) * d) + g1;
        int intb = (int)((double)(b1 - b2) * d) + b1;
        return Color.packARGB(intr, intg, intb, inta);
    }

    public Color multiplyC(double d) {
        this.r = (byte)MathHelper.clip((double)(this.r & 0xFF) * d, 0.0, 255.0);
        this.g = (byte)MathHelper.clip((double)(this.g & 0xFF) * d, 0.0, 255.0);
        this.b = (byte)MathHelper.clip((double)(this.b & 0xFF) * d, 0.0, 255.0);
        return this;
    }

    @Override
    public abstract Color copy();

    public int rgb() {
        return (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int argb() {
        return (this.a & 0xFF) << 24 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int rgba() {
        return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a & 0xFF;
    }

    public abstract Color set(int var1);

    public Color set(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        return this;
    }

    public Color set(double r, double g, double b, double a) {
        return this.set((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b), (int)(255.0 * a));
    }

    public Color set(int r, int g, int b, int a) {
        this.r = (byte)r;
        this.g = (byte)g;
        this.b = (byte)b;
        this.a = (byte)a;
        return this;
    }

    public static int packRGBA(byte r, byte g, byte b, byte a) {
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static int packARGB(byte r, byte g, byte b, byte a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int packRGBA(int r, int g, int b, int a) {
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static int packARGB(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int packRGBA(double r, double g, double b, double a) {
        return (int)(r * 255.0) << 24 | (int)(g * 255.0) << 16 | (int)(b * 255.0) << 8 | (int)(a * 255.0);
    }

    public static int packARGB(double r, double g, double b, double a) {
        return (int)(a * 255.0) << 24 | (int)(r * 255.0) << 16 | (int)(g * 255.0) << 8 | (int)(b * 255.0);
    }

    public static int packRGBA(float[] data) {
        return Color.packRGBA(data[0], data[1], data[2], data[3]);
    }

    public static int packARGB(float[] data) {
        return Color.packARGB(data[0], data[1], data[2], data[3]);
    }

    public static void glColourRGBA(int color) {
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public static void glColourRGB(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void glColourARGB(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public boolean equals(Color color) {
        return color != null && this.rgba() == color.rgba();
    }
}

