/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.hammercore.common.chunk;

import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.world.World;

public class ChunkPredicate {
    public final ChunkPredicate parent;
    public final IChunkLoader loader;
    public final ArrayList<LoadableChunk> chunks = new ArrayList();

    public ChunkPredicate(ChunkPredicate parent, IChunkLoader loader) {
        this.parent = parent;
        this.loader = loader;
    }

    public final boolean isKeptLoaded(World world, int x, int z) {
        if (this.loader.shouldChunkBeLoaded(world, x, z)) {
            return true;
        }
        return this.parent == null ? false : this.parent.isKeptLoaded(world, x, z);
    }

    public final ArrayList<LoadableChunk> getAllForcedChunks() {
        this.chunks.clear();
        this.chunks.addAll(this.loader.getForceLoadedChunks());
        if (this.parent != null) {
            this.chunks.addAll(this.parent.getAllForcedChunks());
        }
        return this.chunks;
    }

    public static final class LoadableChunk
    implements Serializable {
        public final int dim;
        public final int x;
        public final int z;

        public LoadableChunk(int dim, int x, int z) {
            this.dim = dim;
            this.x = x;
            this.z = z;
        }

        public int hashCode() {
            return (this.x + this.z * 31) * 31 + this.dim;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LoadableChunk)) {
                return false;
            }
            LoadableChunk b = (LoadableChunk)obj;
            return b.dim == this.dim && b.x == this.x && b.z == this.z;
        }
    }

    public static interface IChunkLoader {
        public boolean shouldChunkBeLoaded(World var1, int var2, int var3);

        public ArrayList<LoadableChunk> getForceLoadedChunks();
    }
}

