/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.solarfluxreborn;

import com.mrdimka.hammercore.ext.TeslaAPI;
import com.pengu.solarfluxreborn.config.BlackHoleStorageConfigs;
import com.pengu.solarfluxreborn.config.DraconicEvolutionConfigs;
import com.pengu.solarfluxreborn.config.ModConfiguration;
import com.pengu.solarfluxreborn.err.NoSolarsRegisteredException;
import com.pengu.solarfluxreborn.gui.GuiHandler;
import com.pengu.solarfluxreborn.init.ModBlocks;
import com.pengu.solarfluxreborn.init.ModItems;
import com.pengu.solarfluxreborn.init.RecipeIO;
import com.pengu.solarfluxreborn.proxy.CommonProxy;
import com.pengu.solarfluxreborn.te.AbstractSolarPanelTileEntity;
import com.pengu.solarfluxreborn.te.SolarPanelTileEntity;
import com.pengu.solarfluxreborn.te.cable.TileCustomCable;
import com.pengu.solarfluxreborn.utility.SFRLog;
import java.io.File;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="solarfluxreborn", name="Solar Flux Reborn", version="2.21r", guiFactory="com.pengu.solarfluxreborn.config.ConfigurationGuiFactory", dependencies="required-after:hammercore@[1.8.4,);after:blackholestorage", acceptedMinecraftVersions="[1.11.2]")
public class SolarFluxReborn {
    @Mod.Instance(value="solarfluxreborn")
    public static SolarFluxReborn instance;
    @SidedProxy(clientSide="com.pengu.solarfluxreborn.proxy.ClientProxy", serverSide="com.pengu.solarfluxreborn.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static File cfgFolder;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent pEvent) {
        String cfg = pEvent.getSuggestedConfigurationFile().getAbsolutePath();
        cfg = cfg.substring(0, cfg.lastIndexOf("."));
        cfgFolder = new File(cfg);
        cfgFolder.mkdirs();
        File main_cfg = new File(cfgFolder, "main.cfg");
        File draconicevolution = new File(cfgFolder, "DraconicEvolution.cfg");
        File blackholestorage = new File(cfgFolder, "BlackHoleStorage.cfg");
        File version_file = new File(cfgFolder, "version.dat");
        ModConfiguration.initialize(main_cfg, version_file);
        DraconicEvolutionConfigs.initialize(draconicevolution);
        BlackHoleStorageConfigs.initialize(blackholestorage);
        GameRegistry.registerTileEntity(SolarPanelTileEntity.class, (String)"solarfluxreborn:solar");
        GameRegistry.registerTileEntity(AbstractSolarPanelTileEntity.class, (String)"solarfluxreborn:draconicsolar");
        GameRegistry.registerTileEntity(TileCustomCable.class, (String)"solarfluxreborn:cable_custom");
        ModBlocks.initialize();
        if (ModBlocks.getSolarPanels().isEmpty()) {
            boolean deleted = main_cfg.delete();
            throw new NoSolarsRegisteredException("No solar panels was registered in config file." + (deleted ? "\nSolarFluxReborn configs were removed." : "Please remove file \"" + main_cfg.getAbsolutePath() + "\" manually.") + "\nTry restarting game.", false);
        }
        ModItems.initialize();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent pEvent) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"com.pengu.solarfluxreborn.intr.waila.WailaIntegrar.registerWAIA");
        proxy.init();
        RecipeIO.reload();
    }

    @Mod.EventHandler
    public void loadWorld(FMLServerStartingEvent e) {
        SFRLog.info("Loading TeslaAPI...", new Object[0]);
        int classesLoaded = TeslaAPI.refreshTeslaClassData();
        SFRLog.info("TeslaAPI loaded " + classesLoaded + "/" + TeslaAPI.allClasses.size() + " required classes.", new Object[0]);
    }

    @Mod.EventHandler
    public void printMessage(FMLServerStartedEvent e) {
        if (ModConfiguration.willNotify) {
            SFRLog.bigWarning(TextFormatting.RED + "WARNING: Your configs have been replaced.", new Object[0]);
            ModConfiguration.updateNotification(false);
        }
    }
}

