/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.solarfluxreborn.blocks.modules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pengu.solarfluxreborn.blocks.modules.SimpleEnergyDispenserModule;
import com.pengu.solarfluxreborn.config.ModConfiguration;
import com.pengu.solarfluxreborn.init.ModItems;
import com.pengu.solarfluxreborn.te.SolarPanelTileEntity;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TraversalEnergyDispenserModule
extends SimpleEnergyDispenserModule {
    private final Set<BlockPos> mVisitedBlocks = Sets.newHashSet();
    private final LinkedList<BlockPos> mBlocksToVisit = Lists.newLinkedList();
    private final Map<BlockPos, EnumFacing> mBlocksToVisitSides = Maps.newHashMap();
    private int mDirectNeighborDiscovered;

    public TraversalEnergyDispenserModule(SolarPanelTileEntity pTileEntity) {
        super(pTileEntity);
    }

    @Override
    protected void searchTargets() {
        if (this.searchFinished()) {
            this.getTargets().clear();
            this.getTargets().addAll(this.mVisitedBlocks);
            this.getmFacings().clear();
            this.getmFacings().putAll(this.mBlocksToVisitSides);
            this.mVisitedBlocks.clear();
            this.discoverNeighbors(((SolarPanelTileEntity)this.getTileEntity()).func_174877_v());
            this.mDirectNeighborDiscovered = this.mBlocksToVisit.size();
        }
        if (this.mVisitedBlocks.size() >= this.mDirectNeighborDiscovered + this.getMaximumExtraTargets()) {
            this.mBlocksToVisit.clear();
        }
        this.progressSearch();
    }

    @Override
    protected int getTargetRefreshRate() {
        return ModConfiguration.getTraversalUpgradeUpdateRate();
    }

    private void progressSearch() {
        if (!this.searchFinished()) {
            BlockPos position = this.mBlocksToVisit.remove();
            this.mVisitedBlocks.add(position);
            this.discoverNeighbors(position);
        }
    }

    private boolean searchFinished() {
        return this.mBlocksToVisit.isEmpty();
    }

    private void discoverNeighbors(BlockPos pPosition) {
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            BlockPos neighbor = pPosition.func_177972_a(direction);
            if (this.mVisitedBlocks.contains(neighbor) || !this.isValidTarget(neighbor, direction)) continue;
            this.mBlocksToVisit.add(neighbor);
            this.mBlocksToVisitSides.put(neighbor, direction.func_176734_d());
        }
    }

    public int getMaximumExtraTargets() {
        return ((SolarPanelTileEntity)this.getTileEntity()).getUpgradeCount(ModItems.mUpgradeTraversal) * ModConfiguration.getTraversalUpgradeIncrease();
    }
}

