/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.solarfluxreborn.config;

import com.pengu.solarfluxreborn.blocks.BlockCable320;
import com.pengu.solarfluxreborn.blocks.BlockCable3200;
import com.pengu.solarfluxreborn.blocks.BlockCable320000;
import com.pengu.solarfluxreborn.config.ModConfiguration;
import com.pengu.solarfluxreborn.config.TierConfiguration;
import com.pengu.solarfluxreborn.utility.SFRLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class RemoteConfigs {
    public static double Cable1;
    public static double Cable2;
    public static double Cable3;
    private static final List<TierConfiguration> mTierConfigurations;
    private static float solarHeight;

    public static void reset() {
        SFRLog.info("Restoring client configs...", new Object[0]);
        mTierConfigurations.clear();
        BlockCable320.TRANSFER_RATE = Cable1;
        BlockCable3200.TRANSFER_RATE = Cable2;
        BlockCable320000.TRANSFER_RATE = Cable3;
        solarHeight = ModConfiguration.getSolarThickness();
        SFRLog.info("...Fine!", new Object[0]);
    }

    public static byte[] pack() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream o = new ObjectOutputStream(baos);
            o.writeInt(ModConfiguration.getTierConfigurations().size());
            for (TierConfiguration c : ModConfiguration.getTierConfigurations()) {
                o.writeInt(c.getCapacity());
                o.writeInt(c.getMaximumEnergyGeneration());
                o.writeInt(c.getMaximumEnergyTransfer());
            }
            o.writeDouble(Cable1);
            o.writeDouble(Cable2);
            o.writeDouble(Cable3);
            o.writeFloat(ModConfiguration.getSolarThickness());
            return baos.toByteArray();
        }
        catch (Throwable throwable) {
            return new byte[0];
        }
    }

    public static void unpack(byte[] data) {
        try {
            SFRLog.info("Accepting client configs...", new Object[0]);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            int size = ois.readInt();
            mTierConfigurations.clear();
            for (int i = 0; i < size; ++i) {
                int cap = ois.readInt();
                int maxGen = ois.readInt();
                int maxTransfer = ois.readInt();
                mTierConfigurations.add(new TierConfiguration(maxGen, maxTransfer, cap));
            }
            BlockCable320.TRANSFER_RATE = ois.readDouble();
            BlockCable3200.TRANSFER_RATE = ois.readDouble();
            BlockCable320000.TRANSFER_RATE = ois.readDouble();
            solarHeight = ois.readFloat();
            SFRLog.info("...Fine!", new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static TierConfiguration getTierConfiguration(int pTierIndex) {
        return mTierConfigurations == null || mTierConfigurations.size() <= pTierIndex ? ModConfiguration.getTierConfiguration(pTierIndex) : mTierConfigurations.get(pTierIndex);
    }

    public static float getSolarHeight() {
        return solarHeight;
    }

    static {
        mTierConfigurations = new ArrayList<TierConfiguration>();
    }
}

