/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.solarfluxreborn.init;

import com.google.common.collect.Lists;
import com.pengu.solarfluxreborn.blocks.SolarPanelBlock;
import com.pengu.solarfluxreborn.config.BlackHoleStorageConfigs;
import com.pengu.solarfluxreborn.config.ModConfiguration;
import com.pengu.solarfluxreborn.items.CraftingItem;
import com.pengu.solarfluxreborn.items.UpgradeItem;
import com.pengu.solarfluxreborn.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ModItems {
    private static final List<CraftingItem> unpreparedSolarPanels = Lists.newArrayList();
    public static final Item mirror = new CraftingItem("mirror");
    public static final Item solarCell1 = new CraftingItem("solarCell1");
    public static final Item solarCell2 = new CraftingItem("solarCell2");
    public static final Item solarCell3 = new CraftingItem("solarCell3");
    public static final Item solarCell4 = new CraftingItem("solarCell4");
    public static Item mUpgradeBlank;
    public static Item mUpgradeEfficiency;
    public static Item mUpgradeLowLight;
    public static Item mUpgradeTraversal;
    public static Item mUpgradeTransferRate;
    public static Item mUpgradeCapacity;
    public static Item mUpgradeFurnace;
    public static final Item solarcelldarkmatter;
    public static final Item unprepareddmsolar;

    private ModItems() {
    }

    public static void initialize() {
        ArrayList infos;
        if (ModConfiguration.addUnprepared) {
            unpreparedSolarPanels.clear();
            for (int tierIndex = 3; tierIndex < ModConfiguration.getTierConfigurations().size(); ++tierIndex) {
                String name = "unpreparedsolar" + tierIndex;
                CraftingItem unprepared = new CraftingItem(name);
                ModItems.register(unprepared, name);
                unpreparedSolarPanels.add(unprepared);
            }
        }
        ModItems.register(mirror, "mirror");
        ModItems.register(solarCell1, "solarcell1");
        ModItems.register(solarCell2, "solarcell2");
        ModItems.register(solarCell3, "solarcell3");
        ModItems.register(solarCell4, "solarcell4");
        if (BlackHoleStorageConfigs.canIntegrate) {
            if (BlackHoleStorageConfigs.solarcellDM) {
                ModItems.register(solarcelldarkmatter, "solarcelldarkmatter");
            }
            if (BlackHoleStorageConfigs.DMSolarRequiresTransformation) {
                ModItems.register(unprepareddmsolar, "unprepareddmsolar");
            }
        }
        boolean anyUpgrade = false;
        if (ModConfiguration.isEfficiencyUpgradeActive()) {
            infos = Lists.newArrayList();
            infos.add(String.format(Lang.localise("upgrade.efficiency"), Float.valueOf(ModConfiguration.getEfficiencyUpgradeIncrease() * 100.0f)));
            infos.add(ModItems.localiseReturnsToScale(ModConfiguration.getEfficiencyUpgradeReturnsToScale()));
            mUpgradeEfficiency = new UpgradeItem("upgradeEfficiency", ModConfiguration.getEfficiencyUpgradeMax(), infos);
            ModItems.register(mUpgradeEfficiency, "upgradeefficiency");
            anyUpgrade = true;
        }
        if (ModConfiguration.isLowLightUpgradeActive()) {
            mUpgradeLowLight = new UpgradeItem("upgradeLowLight", ModConfiguration.getLowLightUpgradeMax(), Lists.newArrayList((Object[])new String[]{Lang.localise("upgrade.low.light")}));
            ModItems.register(mUpgradeLowLight, "upgradelowlight");
            anyUpgrade = true;
        }
        if (ModConfiguration.isTraversalUpgradeActive()) {
            mUpgradeTraversal = new UpgradeItem("upgradeTraversal", ModConfiguration.getTraversalUpgradeMax(), Lists.newArrayList((Object[])new String[]{String.format(Lang.localise("upgrade.traversal"), ModConfiguration.getTraversalUpgradeIncrease())}));
            ModItems.register(mUpgradeTraversal, "upgradetraversal");
            anyUpgrade = true;
        }
        if (ModConfiguration.isTransferRateUpgradeActive()) {
            infos = Lists.newArrayList();
            infos.add(String.format(Lang.localise("upgrade.transfer"), Float.valueOf(ModConfiguration.getTransferRateUpgradeIncrease() * 100.0f)));
            infos.add(ModItems.localiseReturnsToScale(ModConfiguration.getTransferRateUpgradeReturnsToScale()));
            mUpgradeTransferRate = new UpgradeItem("upgradeTransferRate", ModConfiguration.getTransferRateUpgradeMax(), infos);
            ModItems.register(mUpgradeTransferRate, "upgradetransferrate");
            anyUpgrade = true;
        }
        if (ModConfiguration.isCapacityUpgradeActive()) {
            infos = Lists.newArrayList();
            infos.add(String.format(Lang.localise("upgrade.capacity"), Float.valueOf(ModConfiguration.getCapacityUpgradeIncrease() * 100.0f)));
            infos.add(ModItems.localiseReturnsToScale(ModConfiguration.getCapacityUpgradeReturnsToScale()));
            mUpgradeCapacity = new UpgradeItem("upgradeCapacity", ModConfiguration.getCapacityUpgradeMax(), infos);
            ModItems.register(mUpgradeCapacity, "upgradecapacity");
            anyUpgrade = true;
        }
        if (ModConfiguration.isFurnaceUpgradeActive()) {
            mUpgradeFurnace = new UpgradeItem("upgradeFurnace", 1, Lists.newArrayList((Object[])new String[]{Lang.localise("upgrade.furnace")}));
            ModItems.register(mUpgradeFurnace, "upgradefurnace");
            anyUpgrade = true;
        }
        if (anyUpgrade) {
            mUpgradeBlank = new CraftingItem("upgradeBlank");
            ModItems.register(mUpgradeBlank, "upgradeblank");
        }
    }

    public static CraftingItem getUnpreparedForPanel(SolarPanelBlock panel) {
        int tier = panel.getTierIndex() - 3;
        if (unpreparedSolarPanels.size() > tier) {
            return unpreparedSolarPanels.get(tier);
        }
        return null;
    }

    private static String localiseReturnsToScale(float pValue) {
        if (pValue < 1.0f) {
            return Lang.localise("decreasingReturnsToScale");
        }
        if (pValue > 1.0f) {
            return Lang.localise("increasingReturnsToScale");
        }
        return Lang.localise("constantReturnsToScale");
    }

    public static Item register(Item item, String name) {
        item.setRegistryName("solarfluxreborn", name);
        com.mrdimka.hammercore.init.ModItems.items.add(item);
        return (Item)GameRegistry.register((IForgeRegistryEntry)item);
    }

    static {
        solarcelldarkmatter = new CraftingItem("solarcelldarkmatter");
        unprepareddmsolar = new CraftingItem("unprepareddmsolar");
    }
}

