/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.solarfluxreborn.items;

import com.pengu.solarfluxreborn.blocks.AbstractSolarPanelBlock;
import com.pengu.solarfluxreborn.blocks.SolarPanelBlock;
import com.pengu.solarfluxreborn.config.RemoteConfigs;
import com.pengu.solarfluxreborn.utility.Lang;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class SolarPanelItemBlock
extends ItemBlock {
    public SolarPanelItemBlock(Block pBlock) {
        super(pBlock);
    }

    public void func_77624_a(ItemStack pItemStack, EntityPlayer pPlayer, List pList, boolean pBoolean) {
        super.func_77624_a(pItemStack, pPlayer, pList, pBoolean);
        this.addChargeTooltip(pList, pItemStack);
        this.addUpgradeCount(pList, pItemStack);
        if (this.func_179223_d() instanceof AbstractSolarPanelBlock) {
            AbstractSolarPanelBlock solar = (AbstractSolarPanelBlock)this.func_179223_d();
            pList.add(String.format("%s%s:%s %,d", TextFormatting.AQUA, Lang.localise("energy.capacity"), TextFormatting.GRAY, solar.cap));
            pList.add(String.format("%s%s:%s %,d", TextFormatting.AQUA, Lang.localise("energy.generation"), TextFormatting.GRAY, solar.maxGen));
            pList.add(String.format("%s%s:%s %,d", TextFormatting.AQUA, Lang.localise("energy.transfer"), TextFormatting.GRAY, solar.transfer));
            if (pItemStack.func_77942_o() && pItemStack.func_77978_p().func_150297_b("MaxGen", 3) && pItemStack.func_77978_p().func_74762_e("MaxGen") != solar.maxGen) {
                pList.add(TextFormatting.AQUA + "MaxGen: " + TextFormatting.GRAY + pItemStack.func_77978_p().func_74762_e("MaxGen"));
            }
        } else if (this.func_179223_d() instanceof SolarPanelBlock) {
            SolarPanelBlock solar = (SolarPanelBlock)this.func_179223_d();
            this.addCapacityTooltip(pList, pItemStack, solar);
            this.addGenerationTooltip(pList, pItemStack, solar);
            this.addTransferTooltip(pList, pItemStack, solar);
        }
    }

    private void addChargeTooltip(List pList, ItemStack pItemStack) {
        if (this.hasNbtTag(pItemStack, "SFREnergy")) {
            pList.add(String.format("%s%s:%s %,d", TextFormatting.GREEN, Lang.localise("energy.stored"), TextFormatting.GRAY, pItemStack.func_77978_p().func_74762_e("SFREnergy")));
        }
    }

    private void addUpgradeCount(List pList, ItemStack pItemStack) {
        if (this.hasNbtTag(pItemStack, "SFRTLUpgradeCount")) {
            pList.add(String.format("%s%s:%s %,d", TextFormatting.GREEN, Lang.localise("upgrades.installed"), TextFormatting.GRAY, pItemStack.func_77978_p().func_74762_e("SFRTLUpgradeCount")));
        }
    }

    private void addCapacityTooltip(List pList, ItemStack pItemStack, SolarPanelBlock pSolar) {
        int itemValue;
        int value = RemoteConfigs.getTierConfiguration(pSolar.getTierIndex()).getCapacity();
        if (this.hasNbtTag(pItemStack, "SFRTLCapacity") && (itemValue = pItemStack.func_77978_p().func_74762_e("SFRTLCapacity")) != value) {
            value = itemValue;
        }
        pList.add(String.format("%s%s:%s %,d", TextFormatting.AQUA, Lang.localise("energy.capacity"), TextFormatting.GRAY, value));
    }

    private void addGenerationTooltip(List pList, ItemStack pItemStack, SolarPanelBlock pSolar) {
        int value = RemoteConfigs.getTierConfiguration(pSolar.getTierIndex()).getMaximumEnergyGeneration();
        pList.add(String.format("%s%s:%s %,d", TextFormatting.AQUA, Lang.localise("energy.generation"), TextFormatting.GRAY, value));
    }

    private void addTransferTooltip(List pList, ItemStack pItemStack, SolarPanelBlock pSolar) {
        int itemValue;
        int value = RemoteConfigs.getTierConfiguration(pSolar.getTierIndex()).getMaximumEnergyTransfer();
        if (this.hasNbtTag(pItemStack, "SFRTLTransferRate") && (itemValue = pItemStack.func_77978_p().func_74762_e("SFRTLTransferRate")) != value) {
            value = itemValue;
        }
        pList.add(String.format("%s%s:%s %,d", TextFormatting.AQUA, Lang.localise("energy.transfer"), TextFormatting.GRAY, value));
    }

    private boolean hasNbtTag(ItemStack pItemStack, String pNbtTag) {
        return pItemStack.func_77942_o() && pItemStack.func_77978_p().func_74764_b(pNbtTag);
    }
}

