/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.solarfluxreborn.te;

import com.pengu.solarfluxreborn.blocks.StatefulEnergyStorage;
import com.pengu.solarfluxreborn.te.SolarPanelTileEntity;
import net.minecraft.nbt.NBTTagCompound;

public class AbstractSolarPanelTileEntity
extends SolarPanelTileEntity {
    protected int maxGen;
    protected int cap;
    protected int transfer;
    protected String name;

    public AbstractSolarPanelTileEntity() {
    }

    public AbstractSolarPanelTileEntity(String name, int cap, int transfer, int maxGen) {
        super(0);
        this.maxGen = maxGen;
        this.name = name;
        this.mEnergyStorage = new StatefulEnergyStorage(cap, transfer, transfer);
        this.cap = cap;
        this.transfer = transfer;
    }

    @Override
    public int getMaximumEnergyGeneration() {
        return this.maxGen;
    }

    @Override
    public String getTopResource() {
        return "solarfluxreborn:blocks/" + this.name + "_top";
    }

    @Override
    public String getBaseResource() {
        return "solarfluxreborn:blocks/" + this.name + "_base";
    }

    @Override
    public void tick() {
        this.mEnergyStorage.setMaxEnergyStored(this.cap);
        this.mEnergyStorage.setMaxTransfer(this.transfer);
        super.tick();
    }

    @Override
    protected void loadDataFromNBT(NBTTagCompound pNBT) {
        super.loadDataFromNBT(pNBT);
        this.mEnergyStorage.setMaxEnergyStored(this.cap);
        this.mEnergyStorage.setMaxTransfer(this.transfer);
    }
}

