/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.solarfluxreborn.te;

import cofh.api.energy.IEnergyProvider;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.mrdimka.hammercore.common.InterItemStack;
import com.mrdimka.hammercore.common.capabilities.CapabilityEJ;
import com.mrdimka.hammercore.common.inventory.InventoryNonTile;
import com.mrdimka.hammercore.energy.IPowerStorage;
import com.mrdimka.hammercore.tile.TileSyncableTickable;
import com.pengu.solarfluxreborn.blocks.StatefulEnergyStorage;
import com.pengu.solarfluxreborn.blocks.modules.EnergySharingModule;
import com.pengu.solarfluxreborn.blocks.modules.ITileEntityModule;
import com.pengu.solarfluxreborn.blocks.modules.SimpleEnergyDispenserModule;
import com.pengu.solarfluxreborn.blocks.modules.TraversalEnergyDispenserModule;
import com.pengu.solarfluxreborn.config.ModConfiguration;
import com.pengu.solarfluxreborn.config.RemoteConfigs;
import com.pengu.solarfluxreborn.config.TierConfiguration;
import com.pengu.solarfluxreborn.init.ModItems;
import com.pengu.solarfluxreborn.items.UpgradeItem;
import com.pengu.solarfluxreborn.te.AbstractSolarPanelTileEntity;
import com.pengu.solarfluxreborn.utility.Utils;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class SolarPanelTileEntity
extends TileSyncableTickable
implements IInventory,
IEnergyProvider,
IPowerStorage,
IEnergyStorage {
    public static final int INVENTORY_SIZE = 5;
    public static final Range<Integer> UPGRADE_SLOTS = Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(5));
    protected StatefulEnergyStorage mEnergyStorage;
    private int mTierIndex;
    private ITileEntityModule mEnergySharingModule;
    private ITileEntityModule mEnergyDispenserModule = new SimpleEnergyDispenserModule(this);
    private int mCurrentEnergyGeneration;
    private float mSunIntensity;
    private InventoryNonTile mInventory = new InventoryNonTile(5);
    private Map<Item, Integer> mUpgradeCache = Maps.newHashMap();

    public InventoryNonTile getInventory() {
        return this.mInventory;
    }

    public SolarPanelTileEntity() {
        this(0);
    }

    public int getTier() {
        return this.mTierIndex;
    }

    public SolarPanelTileEntity(int pTierIndex) {
        this.mTierIndex = pTierIndex;
        this.mEnergyStorage = new StatefulEnergyStorage(this.getCapacity(), this.getTransfer());
        if (ModConfiguration.doesAutoBalanceEnergy()) {
            this.mEnergySharingModule = new EnergySharingModule(this);
        }
    }

    private TierConfiguration getTierConfiguration() {
        return ModConfiguration.getTierConfigurations().get(this.mTierIndex);
    }

    public void tick() {
        this.updateCurrentEnergyGeneration(Utils.isServer(this.field_145850_b) ? this.field_174879_c.func_177984_a() : this.field_174879_c);
        if (!this.field_145850_b.field_72995_K) {
            if (this.atTickRate(20)) {
                this.refreshUpgradeCache();
            }
            this.mEnergyDispenserModule.tick();
            this.generateEnergy();
            if (this.mEnergySharingModule != null) {
                this.mEnergySharingModule.tick();
            }
            if (this.atTickRate(20)) {
                this.sync();
            }
        }
    }

    public StatefulEnergyStorage getEnergyStorage() {
        return this.mEnergyStorage;
    }

    public int getCurrentEnergyGeneration() {
        return this.mCurrentEnergyGeneration;
    }

    public void setCurrentEnergyGeneration(int pCurrentEnergyGeneration) {
        this.mCurrentEnergyGeneration = pCurrentEnergyGeneration;
    }

    public int getMaximumEnergyGeneration() {
        return this.getMaxGen();
    }

    public void updateCurrentEnergyGeneration(BlockPos pos) {
        this.computeSunIntensity(pos);
        double energyGeneration = (float)this.getMaxGen() * this.mSunIntensity;
        this.mCurrentEnergyGeneration = (int)Math.round(energyGeneration *= 1.0 + (double)ModConfiguration.getEfficiencyUpgradeIncrease() * Math.pow(this.getUpgradeCount(ModItems.mUpgradeEfficiency), ModConfiguration.getEfficiencyUpgradeReturnsToScale()));
    }

    public float getSunIntensity() {
        return this.mSunIntensity;
    }

    public void setSunIntensity(float pSunIntensity) {
        this.mSunIntensity = pSunIntensity;
    }

    public void computeSunIntensity(BlockPos at) {
        if (this.field_145850_b.func_175710_j(at)) {
            float multiplicator = 1.5f - (float)this.getUpgradeCount(ModItems.mUpgradeLowLight) * 0.122f;
            float displacement = 1.2f + (float)this.getUpgradeCount(ModItems.mUpgradeLowLight) * 0.08f;
            float celestialAngleRadians = this.field_145850_b.func_72929_e(1.0f);
            if ((double)celestialAngleRadians > Math.PI) {
                celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
            }
            this.mSunIntensity = multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement));
            this.mSunIntensity = Math.max(0.0f, this.mSunIntensity);
            this.mSunIntensity = Math.min(1.0f, this.mSunIntensity);
            if (this.mSunIntensity > 0.0f) {
                if (this.field_145850_b.func_72896_J()) {
                    this.mSunIntensity *= ModConfiguration.getRainGenerationFactor();
                }
                if (this.field_145850_b.func_72911_I()) {
                    this.mSunIntensity *= ModConfiguration.getThunderGenerationFactor();
                }
            }
        } else {
            this.mSunIntensity = 0.0f;
        }
    }

    protected void generateEnergy() {
        if (this.mCurrentEnergyGeneration > 0) {
            this.getEnergyStorage().receiveEnergy(this.mCurrentEnergyGeneration, false);
        }
    }

    private void refreshUpgradeCache() {
        this.mUpgradeCache.clear();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null || !(itemStack.func_77973_b() instanceof UpgradeItem)) continue;
            if (this.mUpgradeCache.containsKey(itemStack.func_77973_b())) {
                this.mUpgradeCache.put(itemStack.func_77973_b(), itemStack.func_190916_E() + this.mUpgradeCache.get(itemStack.func_77973_b()));
                continue;
            }
            this.mUpgradeCache.put(itemStack.func_77973_b(), itemStack.func_190916_E());
        }
        if (this.getUpgradeCount(ModItems.mUpgradeTraversal) > 0 && this.mEnergyDispenserModule instanceof SimpleEnergyDispenserModule) {
            this.mEnergyDispenserModule = new TraversalEnergyDispenserModule(this);
        } else if (this.getUpgradeCount(ModItems.mUpgradeTraversal) == 0 && this.mEnergyDispenserModule instanceof TraversalEnergyDispenserModule) {
            this.mEnergyDispenserModule = new SimpleEnergyDispenserModule(this);
        }
        this.getEnergyStorage().setMaxTransfer((int)((double)this.getTransfer() * (1.0 + (double)ModConfiguration.getTransferRateUpgradeIncrease() * Math.pow(this.getUpgradeCount(ModItems.mUpgradeTransferRate), ModConfiguration.getTransferRateUpgradeReturnsToScale()))));
        this.getEnergyStorage().setMaxEnergyStored((int)((double)this.getCapacity() * (1.0 + (double)ModConfiguration.getCapacityUpgradeIncrease() * Math.pow(this.getUpgradeCount(ModItems.mUpgradeCapacity), ModConfiguration.getCapacityUpgradeReturnsToScale()))));
    }

    public int getTransfer() {
        if (this instanceof AbstractSolarPanelTileEntity) {
            return ((AbstractSolarPanelTileEntity)this).transfer;
        }
        return RemoteConfigs.getTierConfiguration(this.mTierIndex).getMaximumEnergyTransfer();
    }

    public int getMaxGen() {
        if (this instanceof AbstractSolarPanelTileEntity) {
            return ((AbstractSolarPanelTileEntity)this).getMaximumEnergyGeneration();
        }
        return RemoteConfigs.getTierConfiguration(this.mTierIndex).getMaximumEnergyGeneration();
    }

    public int getCapacity() {
        if (this instanceof AbstractSolarPanelTileEntity) {
            return ((AbstractSolarPanelTileEntity)this).cap;
        }
        return RemoteConfigs.getTierConfiguration(this.mTierIndex).getCapacity();
    }

    public int getTotalUpgradeInstalled() {
        int count = 0;
        for (int value : this.mUpgradeCache.values()) {
            count += value;
        }
        return count;
    }

    public int additionalUpgradeAllowed(ItemStack pItemStack) {
        Item item;
        if (pItemStack != null && (item = pItemStack.func_77973_b()) instanceof UpgradeItem) {
            UpgradeItem upgrade = (UpgradeItem)item;
            return upgrade.getMaximumPerSolarPanel() - this.getUpgradeCount(upgrade);
        }
        return 0;
    }

    public int getUpgradeCount(Item pItem) {
        if (pItem != null) {
            Integer count = this.mUpgradeCache.get(pItem);
            return count == null ? 0 : count;
        }
        return 0;
    }

    protected void loadDataFromNBT(NBTTagCompound pNBT) {
        this.mTierIndex = pNBT.func_74762_e("SFRTierIndex");
        this.mEnergyStorage.setMaxEnergyStored(this.getCapacity());
        this.mEnergyStorage.setMaxTransfer(this.getTransfer());
        this.mInventory.readFromNBT(pNBT);
        this.refreshUpgradeCache();
        this.mEnergyStorage.readFromNBT(pNBT);
        this.mCurrentEnergyGeneration = pNBT.func_74762_e("\u043f\u0457\u0405urrentGen");
        if (this instanceof AbstractSolarPanelTileEntity) {
            AbstractSolarPanelTileEntity t = (AbstractSolarPanelTileEntity)this;
            t.maxGen = pNBT.func_74762_e("MaxGen");
            t.transfer = pNBT.func_74762_e("MaxTransfer");
            t.cap = pNBT.func_74762_e("MaxCap");
        }
    }

    protected void addDataToNBT(NBTTagCompound pNBT) {
        pNBT.func_74768_a("SFRTierIndex", this.mTierIndex);
        this.mInventory.writeToNBT(pNBT);
        this.mEnergyStorage.writeToNBT(pNBT);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing pFrom) {
        return pFrom != EnumFacing.UP;
    }

    @Override
    public int extractEnergy(EnumFacing pFrom, int pMaxExtract, boolean pSimulate) {
        return this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxExtract(), pSimulate);
    }

    public int getEnergyStored() {
        return this.getEnergyStored(EnumFacing.DOWN);
    }

    public void setEnergyStored(int pEnergy) {
        this.getEnergyStorage().setEnergyStored(pEnergy);
    }

    public double getScaledEnergyStoredFraction(int pScale) {
        double v = pScale;
        v *= (double)this.getEnergyStored();
        return v /= (double)this.getMaxEnergyStored();
    }

    public int getPercentageEnergyStored() {
        return (int)this.getScaledEnergyStoredFraction(100);
    }

    @Override
    public int getEnergyStored(EnumFacing pFrom) {
        return this.getEnergyStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(EnumFacing.DOWN);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing pFrom) {
        return this.getEnergyStorage().getMaxEnergyStored();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("hash", this.hashCode()).add("MaxProduction", this.getMaximumEnergyGeneration()).add("energyStorage", (Object)this.getEnergyStorage()).toString();
    }

    public int func_70302_i_() {
        return this.mInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int pSlotIndex) {
        if (pSlotIndex < 0 || pSlotIndex >= this.mInventory.func_70302_i_()) {
            return InterItemStack.NULL_STACK;
        }
        return this.mInventory.func_70301_a(pSlotIndex);
    }

    public ItemStack func_70298_a(int pSlotIndex, int pDecrementAmount) {
        return this.mInventory.func_70298_a(pSlotIndex, pDecrementAmount);
    }

    public void func_70299_a(int pSlotIndex, ItemStack pItemStack) {
        this.mInventory.func_70299_a(pSlotIndex, pItemStack);
    }

    public int func_70297_j_() {
        return this.mInventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer pEntityPlayer) {
        return this.mInventory.isUsableByPlayer(pEntityPlayer, this.field_174879_c);
    }

    public boolean func_94041_b(int pSlotIndex, ItemStack pItemStack) {
        return pItemStack.func_77973_b() instanceof UpgradeItem && this.additionalUpgradeAllowed(pItemStack) >= pItemStack.func_190916_E();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.refreshUpgradeCache();
    }

    public ITextComponent func_145748_c_() {
        return this.mInventory.func_145748_c_();
    }

    public String func_70005_c_() {
        return this.mInventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.mInventory.func_145818_k_();
    }

    public void func_174888_l() {
        this.mInventory.func_174888_l();
    }

    public void func_174886_c(EntityPlayer arg0) {
        this.mInventory.func_174886_c(arg0);
    }

    public int func_174887_a_(int arg0) {
        return this.mInventory.func_174887_a_(arg0);
    }

    public int func_174890_g() {
        return this.mInventory.func_174890_g();
    }

    public void func_174889_b(EntityPlayer arg0) {
        this.mInventory.func_174889_b(arg0);
    }

    public ItemStack func_70304_b(int arg0) {
        return this.mInventory.func_70304_b(arg0);
    }

    public void func_174885_b(int arg0, int arg1) {
        this.mInventory.func_174885_b(arg0, arg1);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.loadDataFromNBT(nbt);
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("SFRTierIndex", this.mTierIndex);
        this.mInventory.writeToNBT(nbt);
        this.mEnergyStorage.writeToNBT(nbt);
        nbt.func_74768_a("\u043f\u0457\u0405urrentGen", this.mCurrentEnergyGeneration);
        if (this instanceof AbstractSolarPanelTileEntity) {
            AbstractSolarPanelTileEntity t = (AbstractSolarPanelTileEntity)this;
            nbt.func_74768_a("MaxGen", t.getMaxGen());
            nbt.func_74768_a("MaxTransfer", t.transfer);
            nbt.func_74768_a("MaxCap", t.cap);
        }
    }

    public String getTopResource() {
        return "solarfluxreborn:blocks/solar" + this.mTierIndex + "_top";
    }

    public String getBaseResource() {
        return "solarfluxreborn:blocks/solar" + this.mTierIndex + "_base";
    }

    public boolean func_191420_l() {
        return this.getInventory().func_191420_l();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((capability == CapabilityEnergy.ENERGY || capability == CapabilityEJ.ENERGY) && facing != EnumFacing.UP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((capability == CapabilityEnergy.ENERGY || capability == CapabilityEJ.ENERGY) && facing != EnumFacing.UP) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergy(EnumFacing.DOWN, maxExtract, simulate);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

