/*
 * Decompiled with CFR 0.152.
 */
package com.pengu.solarfluxreborn.te.cable;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.mrdimka.hammercore.ext.TeslaAPI;
import com.mrdimka.hammercore.tile.TileSyncableTickable;
import com.pengu.solarfluxreborn.network.energy.cable.CableNetwork;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileAbstractCable
extends TileSyncableTickable
implements IEnergyReceiver,
IEnergyProvider,
IEnergyStorage {
    public CableNetwork network;
    public double internal;
    boolean wasUnloaded = false;

    public void tick() {
        if (this.network == null) {
            EnumFacing[] nets = new HashSet();
            for (EnumFacing f : EnumFacing.field_82609_l) {
                TileEntity t = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
                if (!(t instanceof TileAbstractCable)) continue;
                TileAbstractCable w = (TileAbstractCable)t;
                if (w.network == null) continue;
                nets.add(w.network);
            }
            if (nets.size() > 0) {
                CableNetwork netC = null;
                int size = 0;
                for (CableNetwork n : nets.toArray(new CableNetwork[0])) {
                    if (n.wires.size() > size) {
                        size = n.wires.size();
                        netC = n;
                        continue;
                    }
                    if (n.wires.size() != size) continue;
                    netC = n;
                }
                this.network = netC;
            }
            if (this.network == null) {
                this.network = new CableNetwork();
            }
            this.network.connect(this);
        } else {
            this.network.connect(this);
            this.network.markTicked(this);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                TileEntity t = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
                if (!(t instanceof TileAbstractCable)) continue;
                TileAbstractCable w = (TileAbstractCable)t;
                if (w.network == null || w.network == this.network) continue;
                if (w.network.wires.size() > this.network.wires.size()) {
                    w.network.merge(this.network);
                    continue;
                }
                this.network.merge(w.network);
            }
        }
        if (this.network != null && this.network.energy > 0.0) {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                int sent;
                BlockPos p = this.func_174877_v().func_177972_a(f);
                TileEntity t = this.field_145850_b.func_175625_s(p);
                if (t instanceof TileAbstractCable || t == null) continue;
                if (t instanceof IEnergyReceiver) {
                    IEnergyReceiver r = (IEnergyReceiver)t;
                    if (!r.canConnectEnergy(f.func_176734_d())) continue;
                    sent = r.receiveEnergy(f.func_176734_d(), Math.min((int)this.getCapacityAddedToNet(), (int)this.network.energy), false);
                    this.network.energy -= (double)sent;
                    continue;
                }
                if (t.hasCapability(CapabilityEnergy.ENERGY, f.func_176734_d())) {
                    IEnergyStorage r = (IEnergyStorage)t.getCapability(CapabilityEnergy.ENERGY, f.func_176734_d());
                    sent = r.receiveEnergy(Math.min((int)this.getCapacityAddedToNet(), (int)this.network.energy), false);
                    this.network.energy -= (double)sent;
                    continue;
                }
                if (!TeslaAPI.isTeslaConsumer((TileEntity)t)) continue;
                int sent2 = (int)TeslaAPI.givePowerToConsumer((TileEntity)t, (long)Math.min((int)this.getCapacityAddedToNet(), (int)this.network.energy), (boolean)false);
                this.network.energy -= (double)sent2;
            }
        }
    }

    public double getCapacityAddedToNet() {
        return 80.0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing facing) {
        return true;
    }

    @Override
    public int getEnergyStored(EnumFacing facing) {
        if (this.network == null) {
            return 0;
        }
        return (int)this.network.energy;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing facing) {
        if (this.network == null) {
            return 0;
        }
        return (int)this.network.capacity;
    }

    @Override
    public int receiveEnergy(EnumFacing facing, int maxReceive, boolean simulate) {
        if (this.network == null) {
            return 0;
        }
        int energyReceived = (int)Math.min(this.network.capacity - this.network.energy, (double)maxReceive);
        if (!simulate) {
            this.network.energy += (double)energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.network == null) {
            return 0;
        }
        int energyGiven = (int)Math.min(this.network.energy, (double)maxExtract);
        if (!simulate) {
            this.network.energy -= (double)energyGiven;
        }
        return energyGiven;
    }

    public void readNBT(NBTTagCompound nbt) {
        this.internal = nbt.func_74769_h("EnergyStored");
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("EnergyStored", this.internal);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.wasUnloaded = true;
        if (this.network != null) {
            this.network.splitEnergyTo1Wire(this);
            this.network.disconnect(this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.wasUnloaded && this.network != null) {
            CableNetwork network = this.network;
            network.disconnect(this);
            network.energy += this.internal;
        }
    }

    public String getResourceConnection() {
        return "solarfluxreborn:blocks/wire_1";
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.receiveEnergy(EnumFacing.DOWN, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergy(EnumFacing.DOWN, maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.getEnergyStored(EnumFacing.DOWN);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(EnumFacing.DOWN);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

