/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.event;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.ClientProxy;
import com.github.alexthe666.alexsmobs.client.model.ModelWanderingVillagerRider;
import com.github.alexthe666.alexsmobs.client.model.layered.AMModelLayers;
import com.github.alexthe666.alexsmobs.client.render.AMItemstackRenderer;
import com.github.alexthe666.alexsmobs.client.render.LavaVisionFluidRenderer;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBaldEagle;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.message.MessageUpdateEagleControls;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.client.event.EventGetOutlineColor;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ResourceLocation RADIUS_TEXTURE = new ResourceLocation("alexsmobs:textures/falconry_radius.png");
    private boolean previousLavaVision = false;
    private LiquidBlockRenderer previousFluidRenderer;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onOutlineEntityColor(EventGetOutlineColor event) {
        if (event.getEntityIn() instanceof ItemEntity && ItemTags.m_13193_().m_13404_(AMTagRegistry.VOID_WORM_DROPS).m_8110_((Object)((ItemEntity)event.getEntityIn()).m_32055_().m_41720_())) {
            int fromColor = 0;
            int toColor = 2221567;
            float startR = (float)(fromColor >> 16 & 0xFF) / 255.0f;
            float startG = (float)(fromColor >> 8 & 0xFF) / 255.0f;
            float startB = (float)(fromColor & 0xFF) / 255.0f;
            float endR = (float)(toColor >> 16 & 0xFF) / 255.0f;
            float endG = (float)(toColor >> 8 & 0xFF) / 255.0f;
            float endB = (float)(toColor & 0xFF) / 255.0f;
            float f = (float)(Math.cos(0.4f * ((float)event.getEntityIn().f_19797_ + Minecraft.m_91087_().m_91296_())) + 1.0) * 0.5f;
            float r = (endR - startR) * f + startR;
            float g = (endG - startG) * f + startG;
            float b = (endB - startB) * f + startB;
            int j = ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | ((int)(b * 255.0f) & 0xFF) << 0;
            event.setColor(j);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onFogDensity(EntityViewRenderEvent.RenderFogEvent event) {
        FogType fogType = event.getInfo().m_167685_();
        if (Minecraft.m_91087_().f_91074_.m_21023_(AMEffectRegistry.LAVA_VISION) && fogType == FogType.LAVA) {
            RenderSystem.m_157445_((float)-8.0f);
            RenderSystem.m_157443_((float)50.0f);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPreRenderEntity(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof WanderingTrader && event.getEntity().m_20202_() instanceof EntityElephant && !(event.getRenderer().f_115290_ instanceof ModelWanderingVillagerRider)) {
            event.getRenderer().f_115290_ = new ModelWanderingVillagerRider(Minecraft.m_91087_().m_167973_().m_171103_(AMModelLayers.SITTING_WANDERING_VILLAGER));
        }
        if (event.getEntity().m_21023_(AMEffectRegistry.CLINGING) && event.getEntity().m_20192_() < event.getEntity().m_20206_() * 0.45f || event.getEntity().m_21023_(AMEffectRegistry.DEBILITATING_STING) && event.getEntity().m_6336_() == MobType.f_21642_ && event.getEntity().m_20205_() > event.getEntity().m_20206_()) {
            event.getMatrixStack().m_85836_();
            event.getMatrixStack().m_85837_(0.0, (double)(event.getEntity().m_20206_() + 0.1f), 0.0);
            event.getMatrixStack().m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            event.getEntity().f_20884_ = -event.getEntity().f_20884_;
            event.getEntity().f_20883_ = -event.getEntity().f_20883_;
            event.getEntity().f_20886_ = -event.getEntity().f_20886_;
            event.getEntity().f_20885_ = -event.getEntity().f_20885_;
        }
        if (event.getEntity().m_21023_(AMEffectRegistry.ENDER_FLU)) {
            event.getMatrixStack().m_85836_();
            event.getMatrixStack().m_85845_(Vector3f.f_122225_.m_122240_((float)(Math.cos((double)event.getEntity().f_19797_ * 7.0) * Math.PI * (double)1.2f)));
            float vibrate = 0.05f;
            event.getMatrixStack().m_85837_((double)((event.getEntity().m_21187_().nextFloat() - 0.5f) * vibrate), (double)((event.getEntity().m_21187_().nextFloat() - 0.5f) * vibrate), (double)((event.getEntity().m_21187_().nextFloat() - 0.5f) * vibrate));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPostRenderEntity(RenderLivingEvent.Post event) {
        if (event.getEntity().m_21023_(AMEffectRegistry.ENDER_FLU)) {
            event.getMatrixStack().m_85849_();
        }
        if (event.getEntity().m_21023_(AMEffectRegistry.CLINGING) && event.getEntity().m_20192_() < event.getEntity().m_20206_() * 0.45f || event.getEntity().m_21023_(AMEffectRegistry.DEBILITATING_STING) && event.getEntity().m_6336_() == MobType.f_21642_ && event.getEntity().m_20205_() > event.getEntity().m_20206_()) {
            event.getMatrixStack().m_85849_();
            event.getEntity().f_20884_ = -event.getEntity().f_20884_;
            event.getEntity().f_20883_ = -event.getEntity().f_20883_;
            event.getEntity().f_20886_ = -event.getEntity().f_20886_;
            event.getEntity().f_20885_ = -event.getEntity().f_20885_;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderHand(RenderHandEvent event) {
        if (Minecraft.m_91087_().m_91288_() instanceof EntityBaldEagle) {
            event.setCanceled(true);
        }
        if (!Minecraft.m_91087_().f_91074_.m_20197_().isEmpty() && event.getHand() == InteractionHand.MAIN_HAND) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            boolean leftHand = false;
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == AMItemRegistry.FALCONRY_GLOVE) {
                leftHand = player.m_5737_() == HumanoidArm.LEFT;
            } else if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() == AMItemRegistry.FALCONRY_GLOVE) {
                leftHand = player.m_5737_() != HumanoidArm.LEFT;
            }
            for (Entity entity : player.m_20197_()) {
                if (!(entity instanceof EntityBaldEagle)) continue;
                float yaw = player.f_20884_ + (player.f_20883_ - player.f_20884_) * event.getPartialTicks();
                ClientProxy.currentUnrenderedEntities.remove(entity.m_142081_());
                PoseStack matrixStackIn = event.getMatrixStack();
                matrixStackIn.m_85836_();
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                matrixStackIn.m_85837_(leftHand ? (double)-0.8f : (double)0.8f, (double)-0.6f, -1.0);
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
                if (leftHand) {
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                } else {
                    matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
                }
                this.renderEntity(entity, 0.0, 0.0, 0.0, 0.0f, event.getPartialTicks(), matrixStackIn, event.getBuffers(), event.getLight());
                matrixStackIn.m_85849_();
                ClientProxy.currentUnrenderedEntities.add(entity.m_142081_());
            }
        }
        if (Minecraft.m_91087_().f_91074_.m_21211_().m_41720_() == AMItemRegistry.DIMENSIONAL_CARVER && event.getItemStack().m_41720_() == AMItemRegistry.DIMENSIONAL_CARVER) {
            PoseStack matrixStackIn = event.getMatrixStack();
            matrixStackIn.m_85836_();
            ItemInHandRenderer renderer = Minecraft.m_91087_().m_91292_();
            InteractionHand hand = (InteractionHand)MoreObjects.firstNonNull((Object)Minecraft.m_91087_().f_91074_.f_20912_, (Object)InteractionHand.MAIN_HAND);
            float f = Minecraft.m_91087_().f_91074_.m_21324_(event.getPartialTicks());
            float f1 = Mth.m_14179_((float)event.getPartialTicks(), (float)Minecraft.m_91087_().f_91074_.f_19860_, (float)Minecraft.m_91087_().f_91074_.m_146909_());
            float f5 = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
            float f6 = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2)));
            float f10 = -0.2f * Mth.m_14031_((float)(f * (float)Math.PI));
            HumanoidArm handside = hand == InteractionHand.MAIN_HAND ? Minecraft.m_91087_().f_91074_.m_5737_() : Minecraft.m_91087_().f_91074_.m_5737_().m_20828_();
            boolean flag3 = handside == HumanoidArm.RIGHT;
            int l = flag3 ? 1 : -1;
            matrixStackIn.m_85837_((double)((float)l * f5), (double)f6, (double)f10);
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, double x, double y, double z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
            try {
                render = manager.m_114382_(entityIn);
                if (render == null) break block4;
                try {
                    render.m_7392_(entityIn, yaw, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.m_127521_((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
                entityIn.m_7976_(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
                crashreportcategory1.m_128159_("Assigned renderer", (Object)render);
                crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderNameplate(RenderNameplateEvent event) {
        if (Minecraft.m_91087_().m_91288_() instanceof EntityBaldEagle && event.getEntity() == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().m_91091_()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        AMItemstackRenderer.incrementTick();
        if (!AMConfig.shadersCompat) {
            if (Minecraft.m_91087_().f_91074_.m_21023_(AMEffectRegistry.LAVA_VISION)) {
                if (!this.previousLavaVision) {
                    lavaType = RenderType.m_110466_();
                    ItemBlockRenderTypes.setRenderLayer((Fluid)Fluids.f_76195_, (RenderType)lavaType);
                    ItemBlockRenderTypes.setRenderLayer((Fluid)Fluids.f_76194_, (RenderType)lavaType);
                    this.previousFluidRenderer = Minecraft.m_91087_().m_91289_().f_110901_;
                    Minecraft.m_91087_().m_91289_().f_110901_ = new LavaVisionFluidRenderer();
                    this.updateAllChunks();
                }
            } else if (this.previousLavaVision) {
                if (this.previousFluidRenderer != null) {
                    lavaType = RenderType.m_110451_();
                    ItemBlockRenderTypes.setRenderLayer((Fluid)Fluids.f_76195_, (RenderType)lavaType);
                    ItemBlockRenderTypes.setRenderLayer((Fluid)Fluids.f_76194_, (RenderType)lavaType);
                    Minecraft.m_91087_().m_91289_().f_110901_ = this.previousFluidRenderer;
                }
                this.updateAllChunks();
            }
            this.previousLavaVision = Minecraft.m_91087_().f_91074_.m_21023_(AMEffectRegistry.LAVA_VISION);
            if (AMConfig.clingingFlipEffect) {
                if (Minecraft.m_91087_().f_91074_.m_21023_(AMEffectRegistry.CLINGING) && Minecraft.m_91087_().f_91074_.m_20192_() < Minecraft.m_91087_().f_91074_.m_20206_() * 0.45f) {
                    Minecraft.m_91087_().f_91063_.m_109128_(new ResourceLocation("shaders/post/flip.json"));
                } else if (Minecraft.m_91087_().f_91063_.m_109149_() != null && Minecraft.m_91087_().f_91063_.m_109149_().m_110022_().equals("minecraft:shaders/post/flip.json")) {
                    Minecraft.m_91087_().f_91063_.m_109086_();
                }
            }
        }
        if (Minecraft.m_91087_().m_91288_() instanceof EntityBaldEagle) {
            EntityBaldEagle eagle = (EntityBaldEagle)Minecraft.m_91087_().m_91288_();
            LocalPlayer playerEntity = Minecraft.m_91087_().f_91074_;
            if (((EntityBaldEagle)Minecraft.m_91087_().m_91288_()).shouldHoodedReturn() || eagle.m_146910_()) {
                Minecraft.m_91087_().m_91118_((Entity)playerEntity);
                Minecraft.m_91087_().f_91066_.m_92157_(CameraType.values()[AlexsMobs.PROXY.getPreviousPOV()]);
            } else {
                float rotX = Mth.m_14177_((float)(playerEntity.m_146908_() + playerEntity.f_20885_));
                float rotY = playerEntity.m_146909_();
                Entity over = null;
                if (Minecraft.m_91087_().f_91077_ instanceof EntityHitResult) {
                    over = ((EntityHitResult)Minecraft.m_91087_().f_91077_).m_82443_();
                } else {
                    Minecraft.m_91087_().f_91077_ = null;
                }
                boolean loadChunks = playerEntity.f_19853_.m_46468_() % 10L == 0L;
                ((EntityBaldEagle)Minecraft.m_91087_().m_91288_()).directFromPlayer(rotX, rotY, false, over);
                AlexsMobs.NETWORK_WRAPPER.sendToServer((Object)new MessageUpdateEagleControls(Minecraft.m_91087_().m_91288_().m_142049_(), rotX, rotY, loadChunks, over == null ? -1 : over.m_142049_()));
            }
        }
    }

    private void updateAllChunks() {
        if (Minecraft.m_91087_().f_91060_.f_109469_ != null) {
            int length = Minecraft.m_91087_().f_91060_.f_109469_.f_110843_.length;
            for (int i = 0; i < length; ++i) {
                Minecraft.m_91087_().f_91060_.f_109469_.f_110843_[i].f_112792_ = true;
            }
        }
    }
}

