/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.ForgeHooksClient;

public class LavaVisionFluidRenderer
extends LiquidBlockRenderer {
    private static boolean isFaceOccludedByNeighbor(BlockGetter p_239283_0_, BlockPos p_239283_1_, Direction p_239283_2_, float p_239283_3_) {
        BlockPos blockpos = p_239283_1_.m_142300_(p_239283_2_);
        BlockState blockstate = p_239283_0_.m_8055_(blockpos);
        return LavaVisionFluidRenderer.isFaceOccludedByState(p_239283_0_, p_239283_2_, p_239283_3_, blockpos, blockstate);
    }

    private static boolean isFaceOccludedByState(BlockGetter p_239284_0_, Direction p_239284_1_, float p_239284_2_, BlockPos p_239284_3_, BlockState p_239284_4_) {
        if (p_239284_4_.m_60815_()) {
            VoxelShape voxelshape = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)p_239284_2_, (double)1.0);
            VoxelShape voxelshape1 = p_239284_4_.m_60768_(p_239284_0_, p_239284_3_);
            return Shapes.m_83117_((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (Direction)p_239284_1_);
        }
        return false;
    }

    private static boolean isAdjacentFluidSameAs(BlockGetter worldIn, BlockPos pos, Direction side, FluidState state) {
        BlockPos blockpos = pos.m_142300_(side);
        FluidState fluidstate = worldIn.m_6425_(blockpos);
        return fluidstate.m_76152_().m_6212_(state.m_76152_());
    }

    public boolean m_110954_(BlockAndTintGetter lightReaderIn, BlockPos posIn, VertexConsumer vertexBuilderIn, FluidState fluidStateIn) {
        try {
            if (fluidStateIn.m_76153_((Tag)FluidTags.f_13132_)) {
                float f12;
                TextureAtlasSprite[] atextureatlassprite = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)lightReaderIn, (BlockPos)posIn, (FluidState)fluidStateIn);
                BlockState blockstate = lightReaderIn.m_8055_(posIn);
                int i = fluidStateIn.m_76152_().getAttributes().getColor(lightReaderIn, posIn);
                float alpha = (float)AMConfig.lavaOpacity;
                float f = 1.0f;
                float f1 = 0.7f;
                float f2 = 0.7f;
                boolean flag1 = !LavaVisionFluidRenderer.isAdjacentFluidSameAs((BlockGetter)lightReaderIn, posIn, Direction.UP, fluidStateIn);
                boolean flag2 = LavaVisionFluidRenderer.m_110948_((BlockAndTintGetter)lightReaderIn, (BlockPos)posIn, (FluidState)fluidStateIn, (BlockState)blockstate, (Direction)Direction.DOWN) && !LavaVisionFluidRenderer.isFaceOccludedByNeighbor((BlockGetter)lightReaderIn, posIn, Direction.DOWN, 0.8888889f);
                boolean flag3 = LavaVisionFluidRenderer.m_110948_((BlockAndTintGetter)lightReaderIn, (BlockPos)posIn, (FluidState)fluidStateIn, (BlockState)blockstate, (Direction)Direction.NORTH);
                boolean flag4 = LavaVisionFluidRenderer.m_110948_((BlockAndTintGetter)lightReaderIn, (BlockPos)posIn, (FluidState)fluidStateIn, (BlockState)blockstate, (Direction)Direction.SOUTH);
                boolean flag5 = LavaVisionFluidRenderer.m_110948_((BlockAndTintGetter)lightReaderIn, (BlockPos)posIn, (FluidState)fluidStateIn, (BlockState)blockstate, (Direction)Direction.WEST);
                boolean flag6 = LavaVisionFluidRenderer.m_110948_((BlockAndTintGetter)lightReaderIn, (BlockPos)posIn, (FluidState)fluidStateIn, (BlockState)blockstate, (Direction)Direction.EAST);
                if (!(flag1 || flag2 || flag6 || flag5 || flag3 || flag4)) {
                    return false;
                }
                boolean flag7 = false;
                float f3 = lightReaderIn.m_7717_(Direction.DOWN, true);
                float f4 = lightReaderIn.m_7717_(Direction.UP, true);
                float f5 = lightReaderIn.m_7717_(Direction.NORTH, true);
                float f6 = lightReaderIn.m_7717_(Direction.WEST, true);
                float f7 = this.getFluidHeight((BlockGetter)lightReaderIn, posIn, fluidStateIn.m_76152_());
                float f8 = this.getFluidHeight((BlockGetter)lightReaderIn, posIn.m_142128_(), fluidStateIn.m_76152_());
                float f9 = this.getFluidHeight((BlockGetter)lightReaderIn, posIn.m_142126_().m_142128_(), fluidStateIn.m_76152_());
                float f10 = this.getFluidHeight((BlockGetter)lightReaderIn, posIn.m_142126_(), fluidStateIn.m_76152_());
                double d0 = posIn.m_123341_() & 0xF;
                double d1 = posIn.m_123342_() & 0xF;
                double d2 = posIn.m_123343_() & 0xF;
                float f11 = 0.001f;
                float f13 = f12 = flag2 ? 0.001f : 0.0f;
                if (flag1 && !LavaVisionFluidRenderer.isFaceOccludedByNeighbor((BlockGetter)lightReaderIn, posIn, Direction.UP, Math.min(Math.min(f7, f8), Math.min(f9, f10)))) {
                    float f20;
                    float f16;
                    float f19;
                    float f15;
                    float f18;
                    float f14;
                    float f17;
                    float f132;
                    flag7 = true;
                    f7 -= 0.001f;
                    f8 -= 0.001f;
                    f9 -= 0.001f;
                    f10 -= 0.001f;
                    Vec3 vector3d = fluidStateIn.m_76179_((BlockGetter)lightReaderIn, posIn);
                    if (vector3d.f_82479_ == 0.0 && vector3d.f_82481_ == 0.0) {
                        TextureAtlasSprite textureatlassprite1 = atextureatlassprite[0];
                        f132 = textureatlassprite1.m_118367_(0.0);
                        f17 = textureatlassprite1.m_118393_(0.0);
                        f14 = f132;
                        f18 = textureatlassprite1.m_118393_(16.0);
                        f15 = textureatlassprite1.m_118367_(16.0);
                        f19 = f18;
                        f16 = f15;
                        f20 = f17;
                    } else {
                        TextureAtlasSprite textureatlassprite = atextureatlassprite[1];
                        float f21 = (float)Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) - 1.5707964f;
                        float f22 = Mth.m_14031_((float)f21) * 0.25f;
                        float f23 = Mth.m_14089_((float)f21) * 0.25f;
                        float f24 = 8.0f;
                        f132 = textureatlassprite.m_118367_((double)(8.0f + (-f23 - f22) * 16.0f));
                        f17 = textureatlassprite.m_118393_((double)(8.0f + (-f23 + f22) * 16.0f));
                        f14 = textureatlassprite.m_118367_((double)(8.0f + (-f23 + f22) * 16.0f));
                        f18 = textureatlassprite.m_118393_((double)(8.0f + (f23 + f22) * 16.0f));
                        f15 = textureatlassprite.m_118367_((double)(8.0f + (f23 + f22) * 16.0f));
                        f19 = textureatlassprite.m_118393_((double)(8.0f + (f23 - f22) * 16.0f));
                        f16 = textureatlassprite.m_118367_((double)(8.0f + (f23 - f22) * 16.0f));
                        f20 = textureatlassprite.m_118393_((double)(8.0f + (-f23 - f22) * 16.0f));
                    }
                    float f43 = (f132 + f14 + f15 + f16) / 4.0f;
                    float f44 = (f17 + f18 + f19 + f20) / 4.0f;
                    float f45 = (float)atextureatlassprite[0].m_118405_() / (atextureatlassprite[0].m_118410_() - atextureatlassprite[0].m_118409_());
                    float f46 = (float)atextureatlassprite[0].m_118408_() / (atextureatlassprite[0].m_118412_() - atextureatlassprite[0].m_118411_());
                    float f47 = 4.0f / Math.max(f46, f45);
                    f132 = Mth.m_14179_((float)f47, (float)f132, (float)f43);
                    f14 = Mth.m_14179_((float)f47, (float)f14, (float)f43);
                    f15 = Mth.m_14179_((float)f47, (float)f15, (float)f43);
                    f16 = Mth.m_14179_((float)f47, (float)f16, (float)f43);
                    f17 = Mth.m_14179_((float)f47, (float)f17, (float)f44);
                    f18 = Mth.m_14179_((float)f47, (float)f18, (float)f44);
                    f19 = Mth.m_14179_((float)f47, (float)f19, (float)f44);
                    f20 = Mth.m_14179_((float)f47, (float)f20, (float)f44);
                    int j = this.getCombinedAverageLight(lightReaderIn, posIn);
                    float f25 = f4 * f;
                    float f26 = f4 * f1;
                    float f27 = f4 * f2;
                    this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f7, d2 + 0.0, f25, f26, f27, alpha, f132, f17, j);
                    this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f8, d2 + 1.0, f25, f26, f27, alpha, f14, f18, j);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f9, d2 + 1.0, f25, f26, f27, alpha, f15, f19, j);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f10, d2 + 0.0, f25, f26, f27, alpha, f16, f20, j);
                    if (fluidStateIn.m_76171_((BlockGetter)lightReaderIn, posIn.m_7494_())) {
                        this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f7, d2 + 0.0, f25, f26, f27, alpha, f132, f17, j);
                        this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f10, d2 + 0.0, f25, f26, f27, alpha, f16, f20, j);
                        this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f9, d2 + 1.0, f25, f26, f27, alpha, f15, f19, j);
                        this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f8, d2 + 1.0, f25, f26, f27, alpha, f14, f18, j);
                    }
                }
                if (flag2) {
                    float f34 = atextureatlassprite[0].m_118409_();
                    float f35 = atextureatlassprite[0].m_118410_();
                    float f37 = atextureatlassprite[0].m_118411_();
                    float f39 = atextureatlassprite[0].m_118412_();
                    int i1 = this.getCombinedAverageLight(lightReaderIn, posIn.m_7495_());
                    float f40 = f3 * f;
                    float f41 = f3 * f1;
                    float f42 = f3 * f2;
                    this.vertexVanilla(vertexBuilderIn, d0, d1 + (double)f12, d2 + 1.0, f40, f41, f42, alpha, f34, f39, i1);
                    this.vertexVanilla(vertexBuilderIn, d0, d1 + (double)f12, d2, f40, f41, f42, alpha, f34, f37, i1);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f12, d2, f40, f41, f42, alpha, f35, f37, i1);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f12, d2 + 1.0, f40, f41, f42, alpha, f35, f39, i1);
                    flag7 = true;
                }
                for (int l = 0; l < 4; ++l) {
                    boolean flag8;
                    Direction direction;
                    double d6;
                    double d4;
                    double d5;
                    double d3;
                    float f38;
                    float f36;
                    if (l == 0) {
                        f36 = f7;
                        f38 = f10;
                        d3 = d0;
                        d5 = d0 + 1.0;
                        d4 = d2 + (double)0.001f;
                        d6 = d2 + (double)0.001f;
                        direction = Direction.NORTH;
                        flag8 = flag3;
                    } else if (l == 1) {
                        f36 = f9;
                        f38 = f8;
                        d3 = d0 + 1.0;
                        d5 = d0;
                        d4 = d2 + 1.0 - (double)0.001f;
                        d6 = d2 + 1.0 - (double)0.001f;
                        direction = Direction.SOUTH;
                        flag8 = flag4;
                    } else if (l == 2) {
                        f36 = f8;
                        f38 = f7;
                        d3 = d0 + (double)0.001f;
                        d5 = d0 + (double)0.001f;
                        d4 = d2 + 1.0;
                        d6 = d2;
                        direction = Direction.WEST;
                        flag8 = flag5;
                    } else {
                        f36 = f10;
                        f38 = f9;
                        d3 = d0 + 1.0 - (double)0.001f;
                        d5 = d0 + 1.0 - (double)0.001f;
                        d4 = d2;
                        d6 = d2 + 1.0;
                        direction = Direction.EAST;
                        flag8 = flag6;
                    }
                    if (!flag8 || LavaVisionFluidRenderer.isFaceOccludedByNeighbor((BlockGetter)lightReaderIn, posIn, direction, Math.max(f36, f38))) continue;
                    flag7 = true;
                    BlockPos blockpos = posIn.m_142300_(direction);
                    TextureAtlasSprite textureatlassprite2 = atextureatlassprite[1];
                    if (atextureatlassprite[2] != null && lightReaderIn.m_8055_(blockpos).shouldDisplayFluidOverlay(lightReaderIn, blockpos, fluidStateIn)) {
                        textureatlassprite2 = atextureatlassprite[2];
                    }
                    float f48 = textureatlassprite2.m_118367_(0.0);
                    float f49 = textureatlassprite2.m_118367_(8.0);
                    float f50 = textureatlassprite2.m_118393_((double)((1.0f - f36) * 16.0f * 0.5f));
                    float f28 = textureatlassprite2.m_118393_((double)((1.0f - f38) * 16.0f * 0.5f));
                    float f29 = textureatlassprite2.m_118393_(8.0);
                    int k = this.getCombinedAverageLight(lightReaderIn, blockpos);
                    float f30 = l < 2 ? f5 : f6;
                    float f31 = f4 * f30 * f;
                    float f32 = f4 * f30 * f1;
                    float f33 = f4 * f30 * f2;
                    this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f36, d4, f31, f32, f33, alpha, f48, f50, k);
                    this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f38, d6, f31, f32, f33, alpha, f49, f28, k);
                    this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f12, d6, f31, f32, f33, alpha, f49, f29, k);
                    this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f12, d4, f31, f32, f33, alpha, f48, f29, k);
                    if (textureatlassprite2 == atextureatlassprite[2]) continue;
                    this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f12, d4, f31, f32, f33, alpha, f48, f29, k);
                    this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f12, d6, f31, f32, f33, alpha, f49, f29, k);
                    this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f38, d6, f31, f32, f33, alpha, f49, f28, k);
                    this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f36, d4, f31, f32, f33, alpha, f48, f50, k);
                }
                return flag7;
            }
            return super.m_110954_(lightReaderIn, posIn, vertexBuilderIn, fluidStateIn);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void vertexVanilla(VertexConsumer vertexBuilderIn, double x, double y, double z, float red, float green, float blue, float alpha, float u, float v, int packedLight) {
        vertexBuilderIn.m_5483_(x, y, z).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private int getCombinedAverageLight(BlockAndTintGetter lightReaderIn, BlockPos posIn) {
        int i = LevelRenderer.m_109541_((BlockAndTintGetter)lightReaderIn, (BlockPos)posIn);
        int j = LevelRenderer.m_109541_((BlockAndTintGetter)lightReaderIn, (BlockPos)posIn.m_7494_());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    private float getFluidHeight(BlockGetter reader, BlockPos pos, Fluid fluidIn) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = pos.m_142082_(-(j & 1), 0, -(j >> 1 & 1));
            if (reader.m_6425_(blockpos.m_7494_()).m_76152_().m_6212_(fluidIn)) {
                return 1.0f;
            }
            FluidState fluidstate = reader.m_6425_(blockpos);
            if (fluidstate.m_76152_().m_6212_(fluidIn)) {
                float f1 = fluidstate.m_76155_(reader, blockpos);
                if (f1 >= 0.8f) {
                    f += f1 * 10.0f;
                    i += 10;
                    continue;
                }
                f += f1;
                ++i;
                continue;
            }
            if (reader.m_8055_(blockpos).m_60767_().m_76333_()) continue;
            ++i;
        }
        return f / (float)i;
    }
}

