/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityOrca;
import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.SealAIBask;
import com.github.alexthe666.alexsmobs.entity.ai.SealAIDiveForItems;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.BiomeDictionary;

public class EntitySeal
extends Animal
implements ISemiAquatic,
IHerdPanic,
ITargetsDroppedItems {
    private static final EntityDataAccessor<Float> SWIM_ANGLE = SynchedEntityData.m_135353_(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> BASKING = SynchedEntityData.m_135353_(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.m_135353_(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ARCTIC = SynchedEntityData.m_135353_(EntitySeal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float prevSwimAngle;
    public float prevBaskProgress;
    public float baskProgress;
    public float prevDigProgress;
    public float digProgress;
    public int revengeCooldown = 0;
    public UUID feederUUID = null;
    private int baskingTimer = 0;
    private int swimTimer = -1000;
    private int ticksSinceInWater = 0;
    private boolean isLandNavigator;
    public int fishFeedings = 0;

    protected EntitySeal(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    protected SoundEvent m_7515_() {
        return AMSoundRegistry.SEAL_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return AMSoundRegistry.SEAL_HURT;
    }

    protected SoundEvent m_5592_() {
        return AMSoundRegistry.SEAL_HURT;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, (double)0.18f);
    }

    public static boolean canSealSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random random) {
        Optional optional = worldIn.m_45837_(pos);
        if (!Objects.equals(optional, Optional.of(Biomes.f_48211_)) && !Objects.equals(optional, Optional.of(Biomes.f_48172_))) {
            boolean spawnBlock = BlockTags.m_13115_().m_13404_(AMTagRegistry.SEAL_SPAWNS).m_8110_((Object)worldIn.m_8055_(pos.m_7495_()).m_60734_());
            return spawnBlock && worldIn.m_45524_(pos, 0) > 8;
        }
        return worldIn.m_45524_(pos, 0) > 8 && worldIn.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50126_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SealAIBask(this));
        this.f_21345_.m_25352_(1, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AnimalAIFindWater((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new AnimalAILeaveWater((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new AnimalAIHerdPanic((PathfinderMob)this, 1.6));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new SealAIDiveForItems(this));
        this.f_21345_.m_25352_(7, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 7));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityOrca.class, 20.0f, 1.3, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43911_((Tag)ItemTags.m_13193_().m_13404_(AMTagRegistry.SEAL_FOODSTUFFS)), false));
        this.f_21346_.m_25352_(1, new CreatureAITargetItems((PathfinderMob)this, false));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigatorWide((Mob)this, this.f_19853_);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new AquaticMoveController((PathfinderMob)this, 1.5f);
            this.f_21344_ = new SemiAquaticPathNavigator((Mob)this, this.f_19853_);
            this.isLandNavigator = false;
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean prev = super.m_6469_(source, amount);
        if (prev) {
            int fleeTime;
            double range = 15.0;
            this.revengeCooldown = fleeTime = 100 + this.m_21187_().nextInt(150);
            List list = this.f_19853_.m_45976_(this.getClass(), this.m_142469_().m_82377_(range, range / 2.0, range));
            for (EntitySeal gaz : list) {
                gaz.revengeCooldown = fleeTime;
                gaz.setBasking(false);
            }
            this.setBasking(false);
        }
        return prev;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SWIM_ANGLE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BASKING, (Object)false);
        this.f_19804_.m_135372_(DIGGING, (Object)false);
        this.f_19804_.m_135372_(ARCTIC, (Object)false);
    }

    public float getSwimAngle() {
        return ((Float)this.f_19804_.m_135370_(SWIM_ANGLE)).floatValue();
    }

    public void setSwimAngle(float progress) {
        this.f_19804_.m_135381_(SWIM_ANGLE, (Object)Float.valueOf(progress));
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevBaskProgress = this.baskProgress;
        this.prevDigProgress = this.digProgress;
        this.prevSwimAngle = this.getSwimAngle();
        boolean dig = this.isDigging() && this.m_20072_();
        float f2 = (float)(-((double)((float)this.m_20184_().f_82480_) * 57.2957763671875));
        if (this.m_20069_()) {
            this.m_146926_(f2 * 2.5f);
        }
        if (this.m_20069_() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.m_20069_() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isBasking() && this.baskProgress < 5.0f) {
            this.baskProgress += 1.0f;
        }
        if (!this.isBasking() && this.baskProgress > 0.0f) {
            this.baskProgress -= 1.0f;
        }
        if (dig && this.digProgress < 5.0f) {
            this.digProgress += 1.0f;
        }
        if (!dig && this.digProgress > 0.0f) {
            this.digProgress -= 1.0f;
        }
        if (dig && this.f_19853_.m_8055_(this.m_20099_()).m_60815_()) {
            BlockPos posit = this.m_20099_();
            BlockState understate = this.f_19853_.m_8055_(posit);
            for (int i = 0; i < 4 + this.f_19796_.nextInt(2); ++i) {
                double particleX = (float)posit.m_123341_() + this.f_19796_.nextFloat();
                double particleY = (float)posit.m_123342_() + 1.0f;
                double particleZ = (float)posit.m_123343_() + this.f_19796_.nextFloat();
                double motX = this.f_19796_.nextGaussian() * 0.02;
                double motY = 0.1f + this.f_19796_.nextFloat() * 0.2f;
                double motZ = this.f_19796_.nextGaussian() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, understate), particleX, particleY, particleZ, motX, motY, motZ);
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (this.isBasking()) {
                if (this.m_142581_() != null || this.m_27593_() || this.revengeCooldown > 0 || this.m_20072_() || this.m_5448_() != null || this.baskingTimer > 1000 && this.m_21187_().nextInt(100) == 0) {
                    this.setBasking(false);
                }
            } else if (!(this.m_5448_() != null || this.m_27593_() || this.m_142581_() != null || this.revengeCooldown != 0 || this.isBasking() || this.baskingTimer != 0 || this.m_21187_().nextInt(15) != 0 || this.m_20072_())) {
                this.setBasking(true);
            }
            if (this.revengeCooldown > 0) {
                --this.revengeCooldown;
            }
            if (this.revengeCooldown == 0 && this.m_142581_() != null) {
                this.m_6703_(null);
            }
            float threshold = 0.05f;
            if (this.m_20069_() && this.f_19859_ - this.m_146908_() > threshold) {
                this.setSwimAngle(this.getSwimAngle() + 2.0f);
            } else if (this.m_20069_() && this.f_19859_ - this.m_146908_() < -threshold) {
                this.setSwimAngle(this.getSwimAngle() - 2.0f);
            } else if (this.getSwimAngle() > 0.0f) {
                this.setSwimAngle(Math.max(this.getSwimAngle() - 10.0f, 0.0f));
            } else if (this.getSwimAngle() < 0.0f) {
                this.setSwimAngle(Math.min(this.getSwimAngle() + 10.0f, 0.0f));
            }
            this.setSwimAngle(Mth.m_14036_((float)this.getSwimAngle(), (float)-70.0f, (float)70.0f));
            this.baskingTimer = this.isBasking() ? ++this.baskingTimer : 0;
            if (this.m_20069_()) {
                ++this.swimTimer;
                this.ticksSinceInWater = 0;
            } else {
                ++this.ticksSinceInWater;
                --this.swimTimer;
            }
        }
    }

    public boolean isBasking() {
        return (Boolean)this.f_19804_.m_135370_(BASKING);
    }

    public void setBasking(boolean basking) {
        this.f_19804_.m_135381_(BASKING, (Object)basking);
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.f_19804_.m_135381_(DIGGING, (Object)digging);
    }

    public boolean isArctic() {
        return (Boolean)this.f_19804_.m_135370_(ARCTIC);
    }

    public void setArctic(boolean arctic) {
        this.f_19804_.m_135381_(ARCTIC, (Object)arctic);
    }

    public int m_6062_() {
        return 4800;
    }

    protected int m_7305_(int currentAir) {
        return this.m_6062_();
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setArctic(this.isBiomeArctic((LevelAccessor)worldIn, this.m_142538_()));
        this.m_20301_(this.m_6062_());
        this.m_146926_(0.0f);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Arctic", this.isArctic());
        compound.m_128379_("Basking", this.isBasking());
        compound.m_128405_("BaskingTimer", this.baskingTimer);
        compound.m_128405_("SwimTimer", this.swimTimer);
        compound.m_128405_("FishFeedings", this.fishFeedings);
        if (this.feederUUID != null) {
            compound.m_128362_("FeederUUID", this.feederUUID);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setArctic(compound.m_128471_("Arctic"));
        this.setBasking(compound.m_128471_("Basking"));
        this.baskingTimer = compound.m_128451_("BaskingTimer");
        this.swimTimer = compound.m_128451_("SwimTimer");
        this.fishFeedings = compound.m_128451_("FishFeedings");
        if (compound.m_128403_("FeederUUID")) {
            this.feederUUID = compound.m_128342_("FeederUUID");
        }
    }

    private boolean isBiomeArctic(LevelAccessor worldIn, BlockPos position) {
        ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)worldIn.m_46857_(position).getRegistryName());
        return BiomeDictionary.hasType((ResourceKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
            if (this.isDigging()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.02, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == AMItemRegistry.LOBSTER_TAIL;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntitySeal seal = (EntitySeal)AMEntityRegistry.SEAL.m_20615_((Level)serverWorld);
        seal.setArctic(this.isBiomeArctic((LevelAccessor)serverWorld, this.m_142538_()));
        return seal;
    }

    @Override
    public boolean shouldEnterWater() {
        return !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    @Override
    public boolean shouldLeaveWater() {
        if (!this.m_20197_().isEmpty()) {
            return false;
        }
        if (this.m_5448_() != null && !this.m_5448_().m_20069_()) {
            return true;
        }
        return this.swimTimer > 600;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isBasking();
    }

    @Override
    public int getWaterSearchRange() {
        return 32;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return ItemTags.m_13193_().m_13404_(AMTagRegistry.SEAL_FOODSTUFFS).m_8110_((Object)stack.m_41720_());
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (ItemTags.m_13193_().m_13404_(AMTagRegistry.SEAL_FOODSTUFFS).m_8110_((Object)e.m_32055_().m_41720_())) {
            ++this.fishFeedings;
            this.m_5496_(SoundEvents.f_11788_, this.m_6121_(), this.m_6100_());
            if (this.fishFeedings >= 3) {
                this.feederUUID = e.m_32057_();
                this.fishFeedings = 0;
            }
        } else {
            this.feederUUID = null;
        }
        this.m_5634_(10.0f);
    }

    @Override
    public void onPanic() {
    }

    @Override
    public boolean canPanic() {
        return !this.isBasking();
    }
}

