/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_161;
import net.minecraft.class_2960;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.loader.CharmModule;

public class AdvancementHelper {
    private static final List<class_2960> ADVANCEMENTS_TO_REMOVE = new ArrayList<class_2960>();

    public static void removeAdvancement(class_2960 id) {
        LogHelper.debug(AdvancementHelper.class, "Adding `" + id + "` to list of advancements to remove", new Object[0]);
        ADVANCEMENTS_TO_REMOVE.add(id);
    }

    public static void filterAdvancements(Map<class_2960, class_161.class_162> map) {
        if (ADVANCEMENTS_TO_REMOVE.isEmpty() || map.isEmpty()) {
            return;
        }
        ADVANCEMENTS_TO_REMOVE.forEach(toRemove -> {
            ArrayList keys = new ArrayList(map.keySet());
            AtomicInteger exactMatches = new AtomicInteger();
            keys.stream().filter(a -> a.equals(toRemove)).forEach(a -> {
                LogHelper.debug(AdvancementHelper.class, "> Filtering out exact match `" + a + "`", new Object[0]);
                exactMatches.getAndIncrement();
                map.remove(a);
            });
            if (exactMatches.intValue() > 0) {
                return;
            }
            keys.stream().filter(a -> a.method_12836().equals(toRemove.method_12836())).filter(a -> a.method_12832().startsWith(toRemove.method_12832())).forEach(a -> {
                LogHelper.debug(AdvancementHelper.class, "> Filtering out fuzzy match `" + a + "`", new Object[0]);
                map.remove(a);
            });
        });
    }

    public static <T extends CharmModule> void removeAdvancements(List<T> modules) {
        modules.forEach(module -> AdvancementHelper.removeAdvancement(module.getId()));
    }
}

