/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.helper;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.slf4j.Logger;

public class BiomeHelper {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static class_1959 getBiome(class_3218 level, class_2338 pos) {
        return (class_1959)BiomeHelper.getBiomeHolder(level, pos).comp_349();
    }

    public static class_6880<class_1959> getBiomeHolder(class_3218 level, class_2338 pos) {
        return level.method_22385().method_22393(pos);
    }

    @Nullable
    public static class_1959 getBiomeFromBiomeKey(class_5321<class_1959> biomeKey) {
        return class_5458.field_25933.method_31189(biomeKey).orElse(null);
    }

    public static class_6880<class_1959> getBiomeHolderFromBiomeKey(class_5321<class_1959> biomeKey) {
        return (class_6880)class_5458.field_25933.method_40268(biomeKey).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    @Nullable
    public static class_5321<class_1959> getBiomeKeyFromBiome(class_1959 biome) {
        return class_5458.field_25933.method_29113((Object)biome).orElse(null);
    }

    @Nullable
    public static class_2338 locateBiome(class_2960 id, class_3218 level, class_2338 pos) {
        Predicate<class_6880<class_1959>> biomeCheck = holder -> holder.method_40226(id);
        return BiomeHelper.locateBiome(biomeCheck, level, pos);
    }

    public static class_2338 locateBiome(class_6862<class_1959> tagKey, class_3218 level, class_2338 pos) {
        Predicate<class_6880<class_1959>> biomeCheck = holder -> holder.method_40220(tagKey);
        return BiomeHelper.locateBiome(biomeCheck, level, pos);
    }

    public static class_2338 locateBiome(Predicate<class_6880<class_1959>> biomeCheck, class_3218 level, class_2338 pos) {
        Pair nearestBiome = level.method_42108(biomeCheck, pos, 6400, 32, 64);
        return nearestBiome != null ? (class_2338)nearestBiome.getFirst() : null;
    }

    public static void addSpawnEntry(class_5321<class_1959> biomeKey, class_1311 group, class_1299<?> entity, int weight, int minGroupSize, int maxGroupSize) {
        Predicate<BiomeSelectionContext> context = c -> c.getBiomeKey() == biomeKey;
        BiomeModifications.addSpawn(context, (class_1311)group, entity, (int)weight, (int)minGroupSize, (int)maxGroupSize);
    }

    private static void makeSpawnSettingsMutable(class_5483 settings) {
        Map spawnCosts;
        Map spawners = settings.field_26405;
        if (spawners instanceof ImmutableMap) {
            settings.field_26405 = new HashMap(spawners);
        }
        if ((spawnCosts = settings.field_26406) instanceof ImmutableMap) {
            settings.field_26406 = new HashMap(spawnCosts);
        }
    }
}

