/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.helper;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.moandjiezana.toml.Toml;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.helper.DebugHelper;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.loader.CharmModule;

public class ConfigHelper {
    private static final Map<Field, Object> DEFAULT_PROP_VALUES = new HashMap<Field, Object>();
    private static boolean hasAppliedConfig = false;

    public static Toml readConfig(String modId) {
        Path path = ConfigHelper.getConfigPath(modId);
        File file = path.toFile();
        if (!file.exists()) {
            return new Toml();
        }
        return new Toml().read(path.toFile());
    }

    public static String getQuotedModuleEnabledName(String moduleName) {
        String moduleEnabled = moduleName + " Enabled";
        return "\"" + moduleEnabled + "\"";
    }

    public static boolean moduleExistsInConfig(Toml toml, String moduleName) {
        String quoted = ConfigHelper.getQuotedModuleEnabledName(moduleName);
        return toml.contains(quoted);
    }

    public static boolean isModuleDisabled(Toml toml, String moduleName) {
        String quoted = ConfigHelper.getQuotedModuleEnabledName(moduleName);
        return toml.contains(quoted) && toml.getBoolean(quoted) == false;
    }

    public static boolean isDebugMode(Toml toml) {
        String debugMode = "Core.\"Debug mode\"";
        return toml.contains(debugMode) && toml.getBoolean(debugMode) != false;
    }

    public static <T extends CharmModule> void applyConfig(Toml toml, List<T> modules) {
        modules.forEach(module -> {
            String moduleName = module.getName();
            if (!(!toml.isEmpty() && ConfigHelper.moduleExistsInConfig(toml, moduleName) || module.isEnabledByDefault())) {
                module.setEnabledInConfig(false);
            } else {
                module.setEnabledInConfig(!ConfigHelper.isModuleDisabled(toml, moduleName));
            }
            ArrayList<Field> classFields = new ArrayList<Field>(Arrays.asList(module.getClass().getDeclaredFields()));
            for (Field prop : classFields) {
                try {
                    Config annotation = prop.getDeclaredAnnotation(Config.class);
                    if (annotation == null) continue;
                    prop.setAccessible(true);
                    String propName = annotation.name();
                    if (propName.isEmpty()) {
                        propName = prop.getName();
                    }
                    Object propValue = prop.get(null);
                    if (!hasAppliedConfig) {
                        DEFAULT_PROP_VALUES.put(prop, propValue);
                    }
                    if (!toml.contains(moduleName)) continue;
                    Toml moduleKeys = toml.getTable(moduleName);
                    HashMap mappedKeys = new HashMap();
                    moduleKeys.toMap().forEach((k, v) -> mappedKeys.put(k.replace("\"", ""), v));
                    Object configValue = mappedKeys.get(propName);
                    if (configValue == null) continue;
                    if (propValue instanceof Integer && configValue instanceof Double) {
                        configValue = (int)((Double)configValue).doubleValue();
                    }
                    if (propValue instanceof Integer && configValue instanceof Long) {
                        configValue = (int)((Long)configValue).longValue();
                    }
                    if (propValue instanceof Float && configValue instanceof Double) {
                        configValue = Float.valueOf((float)((Double)configValue).doubleValue());
                    }
                    if (DebugHelper.isDebugMode()) {
                        LogHelper.info(ConfigHelper.class, "In module " + moduleName + ": setting `" + propName + "` to `" + configValue + "`", new Object[0]);
                    }
                    prop.set(null, configValue);
                }
                catch (Exception e) {
                    LogHelper.error(ConfigHelper.class, "Failed to read config for `" + moduleName + "`: " + e.getMessage(), new Object[0]);
                }
            }
        });
        hasAppliedConfig = true;
    }

    public static <T extends CharmModule> void writeConfig(String modId, List<T> modules) {
        Path path = ConfigHelper.getConfigPath(modId);
        CommentedConfig config = TomlFormat.newConfig(LinkedHashMap::new);
        modules.forEach(module -> {
            String moduleName = module.getName();
            if (!module.isAlwaysEnabled()) {
                String field = moduleName + " Enabled";
                config.setComment(field, module.getDescription());
                config.add(field, (Object)module.isEnabledInConfig());
            }
            ArrayList<Field> classFields = new ArrayList<Field>(Arrays.asList(module.getClass().getDeclaredFields()));
            classFields.forEach(prop -> {
                try {
                    Config annotation = prop.getDeclaredAnnotation(Config.class);
                    if (annotation == null) {
                        return;
                    }
                    String propName = annotation.name();
                    String propDescription = annotation.description();
                    Object propValue = prop.get(null);
                    String moduleConfigName = moduleName + "." + propName;
                    config.setComment(moduleConfigName, propDescription);
                    config.add(moduleConfigName, propValue);
                }
                catch (Exception e) {
                    LogHelper.error(ConfigHelper.class, "Failed to write config property `" + prop.getName() + "` in `" + module.getName() + "`", new Object[0]);
                }
            });
        });
        try {
            TomlWriter tomlWriter = new TomlWriter();
            BufferedWriter buffer = Files.newBufferedWriter(path, new OpenOption[0]);
            tomlWriter.write((UnmodifiableConfig)config, (Writer)buffer);
            ((Writer)buffer).close();
            LogHelper.debug(ConfigHelper.class, "Written config to disk", new Object[0]);
        }
        catch (Exception e) {
            LogHelper.error(ConfigHelper.class, "Failed to write config: " + e.getMessage(), new Object[0]);
        }
    }

    public static Map<Field, Object> getDefaultPropValues() {
        return DEFAULT_PROP_VALUES;
    }

    private static Path getConfigPath(String modId) {
        String configPath = FabricLoader.getInstance().getConfigDir() + "/" + modId + ".toml";
        return Paths.get(configPath, new String[0]);
    }
}

