/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.loader;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import svenhjol.charm.annotation.ClientModule;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.loader.ModuleLoader;

public class ClientLoader<T extends CharmModule, L extends ModuleLoader<T>>
extends ModuleLoader<T> {
    private final Map<class_2960, T> ALL_MODULES_BY_ID = new HashMap<class_2960, T>();
    private final Map<Class<? extends T>, T> ALL_MODULES_BY_CLASS = new HashMap<Class<? extends T>, T>();
    private final L loader;

    public ClientLoader(String modId, L loader, String basePackage) {
        super(modId, basePackage);
        this.loader = loader;
        this.getModules().forEach(module -> {
            this.ALL_MODULES_BY_ID.put(module.getId(), module);
            this.ALL_MODULES_BY_CLASS.put(module.getClass(), module);
        });
    }

    @Override
    protected String getModuleAnnotation() {
        return "Lsvenhjol/charm/annotation/ClientModule;";
    }

    @Override
    protected void setupModuleAnnotations(Class<T> clazz, T module) throws IllegalStateException {
        if (!clazz.isAnnotationPresent(ClientModule.class)) {
            throw new RuntimeException("[ClientLoader] Missing annotation for client module `" + clazz + "`");
        }
        ClientModule annotation = clazz.getAnnotation(ClientModule.class);
        ((CharmModule)module).setModId(this.getModId());
        ((CharmModule)module).setPriority(annotation.priority());
        ((CharmModule)module).addDependencyCheck(m -> ((ModuleLoader)this.loader).isEnabled(annotation.module()));
    }

    public Optional<T> getModule(Class<? extends T> clazz) {
        return Optional.ofNullable((CharmModule)this.ALL_MODULES_BY_CLASS.get(clazz));
    }

    public Map<class_2960, T> getAllModules() {
        return this.ALL_MODULES_BY_ID;
    }
}

