/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.loader;

import com.moandjiezana.toml.Toml;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.helper.AdvancementHelper;
import svenhjol.charm.helper.ConfigHelper;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.loader.ModuleLoader;
import svenhjol.charm.mixin.BaseMixinConfigPlugin;
import svenhjol.charm.module.core.Core;

public class CommonLoader<T extends CharmModule>
extends ModuleLoader<T> {
    private static final Map<class_2960, CharmModule> ALL_MODULES = new HashMap<class_2960, CharmModule>();
    private final Map<Class<? extends T>, T> MODULES_BY_CLASS = new HashMap<Class<? extends T>, T>();

    public CommonLoader(String modId, String basePackage) {
        super(modId, basePackage);
    }

    @Override
    public void register() {
        super.register();
        this.getModules().forEach(module -> {
            ALL_MODULES.put(module.getId(), (CharmModule)module);
            this.MODULES_BY_CLASS.put(module.getClass(), module);
        });
    }

    @Override
    protected void dependencies() {
        this.getModules().forEach(module -> module.addDependencyCheck(m -> !BaseMixinConfigPlugin.isMixinDisabled(m.getName())));
        super.dependencies();
    }

    @Override
    protected void run() {
        super.run();
        AdvancementHelper.removeAdvancements(CommonLoader.getAllModules().values().stream().filter(m -> !Core.doAdvancements || !m.isEnabled()).collect(Collectors.toList()));
    }

    @Override
    protected String getModuleAnnotation() {
        return "Lsvenhjol/charm/annotation/CommonModule;";
    }

    @Override
    protected void setupModuleAnnotations(Class<T> clazz, T module) throws IllegalStateException {
        if (!clazz.isAnnotationPresent(CommonModule.class)) {
            throw new RuntimeException("[CommonLoader] Missing annotation for module `" + clazz + "`");
        }
        CommonModule annotation = clazz.getAnnotation(CommonModule.class);
        ((CharmModule)module).setModId(this.getModId());
        ((CharmModule)module).setPriority(annotation.priority());
        ((CharmModule)module).setAlwaysEnabled(annotation.alwaysEnabled());
        ((CharmModule)module).setDescription(annotation.description());
        ((CharmModule)module).setEnabledByDefault(annotation.enabledByDefault());
        ((CharmModule)module).setEnabled(((CharmModule)module).isEnabledByDefault());
    }

    @Override
    protected void setupModuleConfig(List<T> modules) {
        Toml toml = ConfigHelper.readConfig(this.getModId());
        ConfigHelper.applyConfig(toml, modules);
        modules.forEach(module -> module.setEnabled(!ConfigHelper.isModuleDisabled(toml, module.getName())));
        ConfigHelper.writeConfig(this.getModId(), modules);
    }

    public Optional<T> getModule(Class<? extends T> clazz) {
        return Optional.ofNullable((CharmModule)this.MODULES_BY_CLASS.get(clazz));
    }

    public static Map<class_2960, CharmModule> getAllModules() {
        return ALL_MODULES;
    }
}

