/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.block_of_ender_pearls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1614;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3614;
import svenhjol.charm.Charm;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.annotation.Config;
import svenhjol.charm.api.event.AddEntityCallback;
import svenhjol.charm.helper.AdvancementHelper;
import svenhjol.charm.helper.PlayerHelper;
import svenhjol.charm.helper.WorldHelper;
import svenhjol.charm.init.CharmAdvancements;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.block_of_ender_pearls.EnderPearlBlock;
import svenhjol.charm.module.block_of_ender_pearls.FormEndermiteGoal;
import svenhjol.charm.module.extra_wandering_trades.ExtraWanderingTrades;

@CommonModule(mod="charm", description="Ender pearl storage. A silverfish will be converted to an endermite upon touching an ender pearl block.\nEating a chorus fruit will teleport you to the nearest ender pearl block.")
public class BlockOfEnderPearls
extends CharmModule {
    public static EnderPearlBlock ENDER_PEARL_BLOCK;
    public static final class_2960 TRIGGER_CONVERTED_SILVERFISH;
    public static final class_2960 TRIGGER_TELEPORTED_TO_ENDER_PEARL_BLOCK;
    @Config(name="Chorus teleport range", description="A chorus fruit will teleport you to an ender pearl block within this range (in blocks).")
    public static int teleportRange;
    @Config(name="Chorus fruit teleport", description="If true, eating a chorus fruit while in range of an ender pearl block will teleport you to it.")
    public static boolean chorusTeleport;
    @Config(name="Convert silverfish to endermite", description="If true, a silverfish has a chance to be converted into an endermite when it is next to an ender pearl block.")
    public static boolean convertSilverfish;

    @Override
    public void register() {
        ENDER_PEARL_BLOCK = new EnderPearlBlock(this);
        ArrayList<String> disable = new ArrayList<String>();
        if (!chorusTeleport) {
            disable.add("teleport_to_ender_pearl_block");
        }
        if (!convertSilverfish) {
            disable.add("convert_silverfish");
        }
        disable.forEach(a -> AdvancementHelper.removeAdvancement(new class_2960("charm", "block_of_ender_pearls/" + a)));
    }

    @Override
    public void runWhenEnabled() {
        AddEntityCallback.EVENT.register(this::addGoalToSilverfish);
        ExtraWanderingTrades.registerRareItem((class_1935)ENDER_PEARL_BLOCK, 1, 8);
    }

    public static boolean tryChorusTeleport(class_1309 entity, class_1799 stack) {
        double z;
        double y;
        if (!Charm.LOADER.isEnabled(BlockOfEnderPearls.class) || !chorusTeleport) {
            return false;
        }
        if (entity.field_6002.field_9236) {
            return false;
        }
        class_2338 pos = entity.method_24515();
        class_3218 level = (class_3218)entity.field_6002;
        HashMap candidates = new HashMap();
        class_2338.method_20437((class_2338)pos.method_10069(-teleportRange, -teleportRange, -teleportRange), (class_2338)pos.method_10069(teleportRange, teleportRange, teleportRange)).forEach(p -> {
            class_2338 above = p.method_10086(1);
            class_2680 state = level.method_8320(p);
            if (state.method_26204() != ENDER_PEARL_BLOCK) {
                return;
            }
            if (above.equals((Object)pos)) {
                return;
            }
            class_2680 state1 = level.method_8320(p.method_10086(1));
            class_2680 state2 = level.method_8320(p.method_10086(2));
            if (state1.method_26207() != class_3614.field_15959 || state2.method_26207() != class_3614.field_15959) {
                return;
            }
            double dist = WorldHelper.getDistanceSquared(pos, above);
            candidates.put(dist, above);
        });
        if (candidates.isEmpty()) {
            return false;
        }
        class_2338 target = (class_2338)candidates.get(Collections.min(candidates.keySet()));
        if (target == null) {
            return false;
        }
        double x = (double)target.method_10263() + 0.5;
        boolean didTeleport = entity.method_6082(x, y = (double)target.method_10264(), z = (double)target.method_10260() + 0.5, true);
        if (!didTeleport) {
            return false;
        }
        class_3414 teleportSound = class_3417.field_14890;
        level.method_43128(null, x, y, z, teleportSound, class_3419.field_15248, 1.0f, 1.0f);
        entity.method_5783(teleportSound, 1.0f, 1.0f);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            player.method_7357().method_7906(class_1802.field_8233, 20);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
                BlockOfEnderPearls.triggerTeleported((class_3222)player);
            }
        }
        return true;
    }

    private class_1269 addGoalToSilverfish(class_1297 entity) {
        if (!convertSilverfish) {
            return class_1269.field_5811;
        }
        if (!(entity instanceof class_1614)) {
            return class_1269.field_5811;
        }
        class_1614 silverfish = (class_1614)entity;
        if (silverfish.field_6201.method_19048().noneMatch(g -> g.method_19058() instanceof FormEndermiteGoal)) {
            silverfish.field_6201.method_6277(2, (class_1352)new FormEndermiteGoal(silverfish));
        }
        return class_1269.field_5812;
    }

    public static void triggerConvertedSilverfishForNearbyPlayers(class_3218 level, class_2338 pos) {
        PlayerHelper.getPlayersInRange((class_1937)level, pos).forEach(player -> CharmAdvancements.ACTION_PERFORMED.trigger((class_3222)player, TRIGGER_CONVERTED_SILVERFISH));
    }

    public static void triggerTeleported(class_3222 playerEntity) {
        CharmAdvancements.ACTION_PERFORMED.trigger(playerEntity, TRIGGER_TELEPORTED_TO_ENDER_PEARL_BLOCK);
    }

    static {
        TRIGGER_CONVERTED_SILVERFISH = new class_2960("charm", "converted_silverfish");
        TRIGGER_TELEPORTED_TO_ENDER_PEARL_BLOCK = new class_2960("charm", "teleported_to_ender_pearl_block");
        teleportRange = 16;
        chorusTeleport = true;
        convertSilverfish = true;
    }
}

