/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.extra_wandering_trades;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.helper.LogHelper;
import svenhjol.charm.helper.VillagerHelper;
import svenhjol.charm.loader.CharmModule;

@CommonModule(mod="charm", description="Adds Charm items as trades for the Wandering Trader.")
public class ExtraWanderingTrades
extends CharmModule {
    private static final Map<class_1935, Pair<Integer, Integer>> ITEMS = new HashMap<class_1935, Pair<Integer, Integer>>();
    private static final Map<class_1935, Pair<Integer, Integer>> RARE_ITEMS = new HashMap<class_1935, Pair<Integer, Integer>>();

    @Override
    public void runWhenEnabled() {
        Integer minCost;
        Integer maxCount;
        class_1935 item;
        for (Map.Entry<class_1935, Pair<Integer, Integer>> entry : ITEMS.entrySet()) {
            item = entry.getKey();
            maxCount = (Integer)entry.getValue().getFirst();
            minCost = (Integer)entry.getValue().getSecond();
            this.addTrade(item, maxCount, minCost, false);
        }
        for (Map.Entry<class_1935, Pair<Integer, Integer>> entry : RARE_ITEMS.entrySet()) {
            item = entry.getKey();
            maxCount = (Integer)entry.getValue().getFirst();
            minCost = (Integer)entry.getValue().getSecond();
            LogHelper.debug(this.getClass(), "rare: " + item.method_8389().method_7876() + ", count: " + maxCount + ", cost: " + minCost, new Object[0]);
            this.addTrade(item, maxCount, minCost, true);
        }
    }

    public static void registerItem(class_1935 item, int maxCount, int minCost) {
        ITEMS.put(item, (Pair<Integer, Integer>)Pair.of((Object)maxCount, (Object)minCost));
    }

    public static void registerRareItem(class_1935 item, int maxCount, int minCost) {
        RARE_ITEMS.put(item, (Pair<Integer, Integer>)Pair.of((Object)maxCount, (Object)minCost));
    }

    private void addTrade(class_1935 item, int maxCount, int minCost, boolean isRare) {
        String[] itemKey = item.method_8389().method_7876().split("\\.");
        LogHelper.debug(this.getClass(), (isRare ? "rare" : "normal") + ": " + itemKey[itemKey.length - 1] + ", count: " + maxCount + ", cost: " + minCost, new Object[0]);
        VillagerHelper.addWanderingTrade((entity, random) -> {
            class_1799 in = new class_1799((class_1935)class_1802.field_8687, minCost);
            class_1799 out = new class_1799(item, maxCount);
            return new class_1914(in, out, 1, 1, 1.0f);
        }, isRare);
    }
}

