/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.raid_horns;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3765;
import net.minecraft.class_3769;
import net.minecraft.class_5304;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import svenhjol.charm.item.CharmItem;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.raid_horns.RaidHorns;

public class RaidHornItem
extends CharmItem {
    public RaidHornItem(CharmModule module) {
        super(module, "raid_horn", new class_1792.class_1793().method_7889(1).method_7895(4).method_7892(class_1761.field_7932));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 user, class_1268 hand) {
        class_1799 horn = user.method_5998(hand);
        if (!level.field_9236) {
            user.method_6019(hand);
        }
        return class_1271.method_22428((Object)horn);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 user, int remainingUseTicks) {
        if (level.field_9236) {
            return;
        }
        if (RaidHornItem.getPullProgress(this.method_7881(stack) - remainingUseTicks) < 1.0f) {
            return;
        }
        class_2338 pos = user.method_24515();
        class_3218 serverLevel = (class_3218)level;
        if (!(user instanceof class_1657)) {
            return;
        }
        class_3222 player = (class_3222)user;
        if (serverLevel.method_19503(pos)) {
            class_3765 raid = serverLevel.method_19502(pos);
            if (raid != null) {
                raid.method_16506();
                this.playCallOffRaidSound(serverLevel, user.method_24515());
                RaidHorns.triggerCalledOff(player);
            } else {
                this.playFailSound(serverLevel, user.method_24515());
            }
        } else {
            boolean result = this.trySpawnPillagers(serverLevel, (class_1657)user);
            if (result) {
                this.playCallPatrolSound(serverLevel, user.method_24515());
                RaidHorns.triggerSummoned(player);
            } else {
                this.playFailSound(serverLevel, user.method_24515());
            }
        }
        player.method_7357().method_7906((class_1792)this, 100);
        stack.method_7956(1, (class_1309)player, e -> e.method_20235(class_1304.field_6173));
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public static float getPullProgress(int useTicks) {
        float f = (float)useTicks / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private boolean trySpawnPillagers(class_3218 level, class_1657 player) {
        class_3769 patrolSpawner = null;
        List spawners = level.field_25141;
        for (class_5304 spawner : spawners) {
            if (!(spawner instanceof class_3769)) continue;
            patrolSpawner = (class_3769)spawner;
            break;
        }
        if (patrolSpawner == null) {
            return false;
        }
        class_5819 random = level.method_8409();
        int j = (24 + random.method_43048(24)) * (random.method_43056() ? -1 : 1);
        int k = (24 + random.method_43048(24)) * (random.method_43056() ? -1 : 1);
        class_2338.class_2339 mutable = player.method_24515().method_25503().method_10100(j, 0, k);
        if (!level.method_22341(mutable.method_10263() - 10, mutable.method_10264() - 10, mutable.method_10260() - 10, mutable.method_10263() + 10, mutable.method_10264() + 10, mutable.method_10260() + 10)) {
            return false;
        }
        class_6880 holder = level.method_23753((class_2338)mutable);
        if (holder.method_40220(class_6908.field_37382)) {
            return false;
        }
        boolean spawned = false;
        int n = (int)Math.ceil(level.method_8404((class_2338)mutable).method_5457()) + 1;
        for (int o = 0; o < n; ++o) {
            mutable.method_33098(level.method_8598(class_2902.class_2903.field_13203, (class_2338)mutable).method_10264());
            boolean result = patrolSpawner.method_16575(level, (class_2338)mutable, random, o == 0);
            if (!result) continue;
            spawned = true;
            mutable.method_33097(mutable.method_10263() + random.method_43048(5) - random.method_43048(5));
            mutable.method_33099(mutable.method_10260() + random.method_43048(5) - random.method_43048(5));
        }
        patrolSpawner.field_16652 = 12000;
        return spawned;
    }

    private void playCallPatrolSound(class_3218 level, class_2338 pos) {
        level.method_8396(null, pos, RaidHorns.CALL_PATROL_SOUND, class_3419.field_15248, (float)RaidHorns.volume, 0.95f + level.method_8409().method_43057() * 0.15f);
    }

    private void playCallOffRaidSound(class_3218 level, class_2338 pos) {
        level.method_8396(null, pos, RaidHorns.CALL_OFF_RAID_SOUND, class_3419.field_15248, (float)RaidHorns.volume - 0.1f, 0.95f + level.method_8409().method_43057() * 0.15f);
    }

    private void playFailSound(class_3218 level, class_2338 pos) {
        level.method_8396(null, pos, RaidHorns.SQUEAK_SOUND, class_3419.field_15248, (float)RaidHorns.volume - 0.2f, 0.95f + level.method_8409().method_43057() * 0.15f);
    }
}

