/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.shulker_box_tooltip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.api.event.HoverSortItemsCallback;
import svenhjol.charm.helper.TagHelper;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.hover_sorting.HoverSorting;
import svenhjol.charm.module.inventory_tidying.InventoryTidyingHandler;

@CommonModule(mod="charm", description="A shulker box's contents is shown in the item tooltip when hovering over.")
public class ShulkerBoxTooltip
extends CharmModule {
    @Override
    public void runWhenEnabled() {
        ServerWorldEvents.LOAD.register(this::handleWorldLoad);
        HoverSortItemsCallback.EVENT.register(this::handleSortItems);
    }

    private void handleSortItems(class_3222 player, class_1799 stack, boolean direction) {
        class_2248 class_22482 = class_2248.method_9503((class_1792)stack.method_7909());
        if (class_22482 instanceof class_2480) {
            class_2480 shulkerBoxBlock = (class_2480)class_22482;
            class_2487 shulkerBoxTag = class_1747.method_38072((class_1799)stack);
            class_2586 blockEntity = shulkerBoxTag == null ? shulkerBoxBlock.method_10123(class_2338.field_10980, shulkerBoxBlock.method_9564()) : class_2586.method_11005((class_2338)class_2338.field_10980, (class_2680)shulkerBoxBlock.method_9564(), (class_2487)shulkerBoxTag);
            if (blockEntity instanceof class_2627) {
                class_2627 shulkerBox = (class_2627)blockEntity;
                if (shulkerBox.field_12054.size() < 1) {
                    return;
                }
                ArrayList<class_1799> stacks = new ArrayList<class_1799>((Collection<class_1799>)shulkerBox.field_12054);
                InventoryTidyingHandler.mergeStacks(stacks);
                HoverSortItemsCallback.sortByScrollDirection(stacks, direction);
                class_2371 nonNullList = class_2371.method_10211();
                nonNullList.addAll(stacks);
                shulkerBox.field_12054 = nonNullList;
                shulkerBox.method_38240(stack);
            }
        }
    }

    private void handleWorldLoad(MinecraftServer server, class_3218 level) {
        if (level.method_27983() == class_1937.field_25179) {
            List<class_2248> boxes = TagHelper.getBlockValues((class_6862<class_2248>)class_3481.field_21490);
            for (class_2248 box : boxes) {
                if (HoverSorting.SORTABLE.contains(box)) continue;
                HoverSorting.SORTABLE.add((class_1935)box);
            }
        }
    }
}

