/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.variant_chests;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1492;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.enums.IWoodMaterial;
import svenhjol.charm.enums.VanillaWoodMaterial;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.variant_chests.VariantChestBlock;
import svenhjol.charm.module.variant_chests.VariantChestBlockEntity;
import svenhjol.charm.module.variant_chests.VariantChestBoatRecipe;
import svenhjol.charm.module.variant_chests.VariantTrappedChestBlock;
import svenhjol.charm.module.variant_chests.VariantTrappedChestBlockEntity;
import svenhjol.charm.registry.CommonRegistry;

@CommonModule(mod="charm", priority=10, description="Chests available in all types of vanilla wood.")
public class VariantChests
extends CharmModule {
    public static final class_2960 NORMAL_ID = new class_2960("charm", "variant_chest");
    public static final class_2960 TRAPPED_ID = new class_2960("charm", "trapped_chest");
    public static final Map<IWoodMaterial, VariantChestBlock> NORMAL_CHEST_BLOCKS = new HashMap<IWoodMaterial, VariantChestBlock>();
    public static final Map<IWoodMaterial, VariantTrappedChestBlock> TRAPPED_CHEST_BLOCKS = new HashMap<IWoodMaterial, VariantTrappedChestBlock>();
    public static class_2591<VariantChestBlockEntity> NORMAL_BLOCK_ENTITY;
    public static class_2591<VariantTrappedChestBlockEntity> TRAPPED_BLOCK_ENTITY;
    public static final class_2960 VARIANT_CHEST_BOAT_RECIPE_ID;
    public static Map<class_1792, class_1792> CHEST_BOATS;
    public static Map<String, Integer> CHEST_LAYER_COLORS;
    public static class_1866<VariantChestBoatRecipe> VARIANT_CHEST_BOAT_RECIPE;

    @Override
    public void register() {
        NORMAL_BLOCK_ENTITY = CommonRegistry.blockEntity(NORMAL_ID, VariantChestBlockEntity::new, NORMAL_CHEST_BLOCKS.values().toArray(new class_2248[0]));
        TRAPPED_BLOCK_ENTITY = CommonRegistry.blockEntity(TRAPPED_ID, VariantTrappedChestBlockEntity::new, TRAPPED_CHEST_BLOCKS.values().toArray(new class_2248[0]));
        for (VanillaWoodMaterial type : VanillaWoodMaterial.values()) {
            VariantChests.registerChest(this, type);
            VariantChests.registerTrappedChest(this, type);
        }
        VARIANT_CHEST_BOAT_RECIPE = CommonRegistry.recipeSerializer(VARIANT_CHEST_BOAT_RECIPE_ID.toString(), new class_1866(VariantChestBoatRecipe::new));
        CHEST_BOATS.put(class_1802.field_8094, class_1802.field_38213);
        CHEST_BOATS.put(class_1802.field_8442, class_1802.field_38218);
        CHEST_BOATS.put(class_1802.field_8138, class_1802.field_38214);
        CHEST_BOATS.put(class_1802.field_8730, class_1802.field_38212);
        CHEST_BOATS.put(class_1802.field_37531, class_1802.field_38215);
        CHEST_BOATS.put(class_1802.field_8533, class_1802.field_38216);
        CHEST_BOATS.put(class_1802.field_8486, class_1802.field_38217);
        CHEST_LAYER_COLORS.put(VanillaWoodMaterial.ACACIA.method_15434(), 14320471);
        CHEST_LAYER_COLORS.put(VanillaWoodMaterial.BIRCH.method_15434(), 16773024);
        CHEST_LAYER_COLORS.put(VanillaWoodMaterial.CRIMSON.method_15434(), 10439279);
        CHEST_LAYER_COLORS.put(VanillaWoodMaterial.DARK_OAK.method_15434(), 7029284);
        CHEST_LAYER_COLORS.put(VanillaWoodMaterial.JUNGLE.method_15434(), 13668199);
        CHEST_LAYER_COLORS.put(VanillaWoodMaterial.MANGROVE.method_15434(), 11491652);
        CHEST_LAYER_COLORS.put(VanillaWoodMaterial.OAK.method_15434(), 15776368);
        CHEST_LAYER_COLORS.put(VanillaWoodMaterial.SPRUCE.method_15434(), 9529406);
        CHEST_LAYER_COLORS.put(VanillaWoodMaterial.WARPED.method_15434(), 4229762);
    }

    @Override
    public void runWhenEnabled() {
        UseEntityCallback.EVENT.register(this::handleEntityInteract);
    }

    private class_1269 handleEntityInteract(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (entity instanceof class_1492) {
            class_1492 horse = (class_1492)entity;
            class_1799 held = player.method_5998(hand);
            class_1792 item = held.method_7909();
            class_2248 block = class_2248.method_9503((class_1792)item);
            if (block instanceof VariantChestBlock && horse.method_6727() && !horse.method_6703() && !horse.method_6109()) {
                horse.method_6704(true);
                horse.method_5783(class_3417.field_14598, 1.0f, (horse.method_6051().method_43057() - horse.method_6051().method_43057()) * 0.2f + 1.0f);
                if (!player.method_31549().field_7477) {
                    held.method_7934(1);
                }
                horse.method_6721();
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    public static VariantChestBlock registerChest(CharmModule module, IWoodMaterial material) {
        VariantChestBlock chest = new VariantChestBlock(module, material, new String[0]);
        NORMAL_CHEST_BLOCKS.put(material, chest);
        CommonRegistry.addBlocksToBlockEntity(NORMAL_BLOCK_ENTITY, new class_2248[]{chest});
        return chest;
    }

    public static VariantTrappedChestBlock registerTrappedChest(CharmModule module, IWoodMaterial material) {
        VariantTrappedChestBlock chest = new VariantTrappedChestBlock(module, material, new String[0]);
        TRAPPED_CHEST_BLOCKS.put(material, chest);
        CommonRegistry.addBlocksToBlockEntity(TRAPPED_BLOCK_ENTITY, new class_2248[]{chest});
        return chest;
    }

    public static int getLayerColor(class_1799 stack) {
        int color = 14655299;
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545("chest_type")) {
            String type = tag.method_10558("chest_type");
            color = CHEST_LAYER_COLORS.getOrDefault(type, color);
        }
        return color;
    }

    static {
        VARIANT_CHEST_BOAT_RECIPE_ID = new class_2960("charm", "crafting_special_variantchestboats");
        CHEST_BOATS = new HashMap<class_1792, class_1792>();
        CHEST_LAYER_COLORS = new HashMap<String, Integer>();
    }
}

