/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.variant_ladders;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2399;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import svenhjol.charm.Charm;
import svenhjol.charm.annotation.CommonModule;
import svenhjol.charm.enums.IWoodMaterial;
import svenhjol.charm.enums.VanillaWoodMaterial;
import svenhjol.charm.helper.RecipeHelper;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.variant_ladders.VariantLadderBlock;

@CommonModule(mod="charm", description="Ladders available in all types of vanilla wood.")
public class VariantLadders
extends CharmModule {
    public static final Map<IWoodMaterial, VariantLadderBlock> LADDER_BLOCKS = new HashMap<IWoodMaterial, VariantLadderBlock>();

    @Override
    public void register() {
        VanillaWoodMaterial.getTypes().forEach(type -> VariantLadders.registerLadder(this, type));
    }

    public static VariantLadderBlock registerLadder(CharmModule module, IWoodMaterial material) {
        VariantLadderBlock ladder = new VariantLadderBlock(module, material);
        LADDER_BLOCKS.put(material, ladder);
        return ladder;
    }

    public static boolean canEnterTrapdoor(class_1937 level, class_2338 pos, class_2680 state) {
        if (Charm.LOADER.isEnabled(VariantLadders.class) && ((Boolean)state.method_11654((class_2769)class_2533.field_11631)).booleanValue()) {
            class_2680 below = level.method_8320(pos.method_10074());
            return LADDER_BLOCKS.values().stream().anyMatch(b -> b == below.method_26204()) && below.method_11654((class_2769)class_2399.field_11253) == state.method_11654((class_2769)class_2533.field_11177);
        }
        return false;
    }

    @Override
    public void runWhenDisabled() {
        RecipeHelper.removeRecipe(new class_2960("charm", "woodcutters/vanilla_ladder_from_planks"));
    }
}

