/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module.variant_mob_textures;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1433;
import net.minecraft.class_1452;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1477;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3989;
import net.minecraft.class_746;
import svenhjol.charm.annotation.ClientModule;
import svenhjol.charm.enums.ICharmEnum;
import svenhjol.charm.loader.CharmModule;
import svenhjol.charm.module.variant_mob_textures.VariantMobRenderer;
import svenhjol.charm.module.variant_mob_textures.VariantMobTextures;

@ClientModule(module=VariantMobTextures.class)
public class VariantMobTexturesClient
extends CharmModule {
    private static final String PREFIX = "textures/entity/";
    private static final class_2960 DEFAULT_SHEEP = new class_2960("textures/entity/sheep/sheep.png");
    public static List<class_2960> chickens = new ArrayList<class_2960>();
    public static List<class_2960> cows = new ArrayList<class_2960>();
    public static List<class_2960> dolphins = new ArrayList<class_2960>();
    public static List<class_2960> snowGolems = new ArrayList<class_2960>();
    public static List<class_2960> squids = new ArrayList<class_2960>();
    public static List<class_2960> pigs = new ArrayList<class_2960>();
    public static List<class_2960> turtles = new ArrayList<class_2960>();
    public static List<class_2960> wolves = new ArrayList<class_2960>();
    public static List<class_2960> wanderingTraders = new ArrayList<class_2960>();
    public static List<class_2960> rareChickens = new ArrayList<class_2960>();
    public static List<class_2960> rareCows = new ArrayList<class_2960>();
    public static List<class_2960> rareDolphins = new ArrayList<class_2960>();
    public static List<class_2960> rareSquids = new ArrayList<class_2960>();
    public static List<class_2960> rarePigs = new ArrayList<class_2960>();
    public static List<class_2960> rareTurtles = new ArrayList<class_2960>();
    public static List<class_2960> rareWolves = new ArrayList<class_2960>();
    public static Map<class_2960, class_2960> wolvesTame = new HashMap<class_2960, class_2960>();
    public static Map<class_2960, class_2960> wolvesAngry = new HashMap<class_2960, class_2960>();
    public static Map<class_1767, class_2960> sheep = new HashMap<class_1767, class_2960>();

    @Override
    public void runWhenEnabled() {
        ClientEntityEvents.ENTITY_LOAD.register(this::handlePlayerJoin);
        if (VariantMobTextures.variantChickens) {
            EntityRendererRegistry.register((class_1299)class_1299.field_6132, VariantMobRenderer.RenderChicken::new);
        }
        if (VariantMobTextures.variantCows) {
            EntityRendererRegistry.register((class_1299)class_1299.field_6085, VariantMobRenderer.RenderCow::new);
        }
        if (VariantMobTextures.variantDolphins) {
            EntityRendererRegistry.register((class_1299)class_1299.field_6087, VariantMobRenderer.RenderDolphin::new);
        }
        if (VariantMobTextures.variantPigs) {
            EntityRendererRegistry.register((class_1299)class_1299.field_6093, VariantMobRenderer.RenderPig::new);
        }
        if (VariantMobTextures.variantSheep) {
            EntityRendererRegistry.register((class_1299)class_1299.field_6115, VariantMobRenderer.RenderSheep::new);
        }
        if (VariantMobTextures.variantSnowGolems) {
            EntityRendererRegistry.register((class_1299)class_1299.field_6047, VariantMobRenderer.RenderSnowGolem::new);
        }
        if (VariantMobTextures.variantSquids) {
            EntityRendererRegistry.register((class_1299)class_1299.field_6114, VariantMobRenderer.RenderSquid::new);
        }
        if (VariantMobTextures.variantTurtles) {
            EntityRendererRegistry.register((class_1299)class_1299.field_6113, VariantMobRenderer.RenderTurtle::new);
        }
        if (VariantMobTextures.variantWolves) {
            EntityRendererRegistry.register((class_1299)class_1299.field_6055, VariantMobRenderer.RenderWolf::new);
        }
        if (VariantMobTextures.variantWanderingTraders) {
            EntityRendererRegistry.register((class_1299)class_1299.field_17713, VariantMobRenderer.RenderWanderingTrader::new);
        }
    }

    public void handlePlayerJoin(class_1297 entity, class_1937 level) {
        int i;
        if (!(entity instanceof class_746)) {
            return;
        }
        class_746 player = (class_746)entity;
        chickens = new ArrayList<class_2960>();
        cows = new ArrayList<class_2960>();
        dolphins = new ArrayList<class_2960>();
        pigs = new ArrayList<class_2960>();
        snowGolems = new ArrayList<class_2960>();
        squids = new ArrayList<class_2960>();
        turtles = new ArrayList<class_2960>();
        wolves = new ArrayList<class_2960>();
        wolvesTame = new HashMap<class_2960, class_2960>();
        wolvesAngry = new HashMap<class_2960, class_2960>();
        wanderingTraders = new ArrayList<class_2960>();
        rareChickens = new ArrayList<class_2960>();
        rareCows = new ArrayList<class_2960>();
        rareDolphins = new ArrayList<class_2960>();
        rarePigs = new ArrayList<class_2960>();
        rareSquids = new ArrayList<class_2960>();
        rareTurtles = new ArrayList<class_2960>();
        rareWolves = new ArrayList<class_2960>();
        chickens.add(new class_2960("textures/entity/chicken.png"));
        cows.add(new class_2960("textures/entity/cow/cow.png"));
        dolphins.add(new class_2960("textures/entity/dolphin.png"));
        pigs.add(new class_2960("textures/entity/pig/pig.png"));
        snowGolems.add(new class_2960("textures/entity/snow_golem.png"));
        squids.add(new class_2960("textures/entity/squid/squid.png"));
        turtles.add(new class_2960("textures/entity/turtle/big_sea_turtle.png"));
        wanderingTraders.add(new class_2960("textures/entity/wandering_trader.png"));
        class_2960 wolf = new class_2960("textures/entity/wolf/wolf.png");
        wolves.add(wolf);
        wolvesTame.put(wolf, new class_2960("textures/entity/wolf/wolf_tame.png"));
        wolvesAngry.put(wolf, new class_2960("textures/entity/wolf/wolf_angry.png"));
        for (i = 1; i <= 5; ++i) {
            this.addCustomTextures(chickens, MobType.CHICKEN, "chicken" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addCustomTextures(rareChickens, MobType.CHICKEN, "rare_chicken" + i);
        }
        for (i = 1; i <= 3; ++i) {
            this.addCustomTextures(dolphins, MobType.DOLPHIN, "dolphin" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addCustomTextures(rareDolphins, MobType.DOLPHIN, "rare_dolphin" + i);
        }
        for (i = 1; i <= 3; ++i) {
            this.addCustomTextures(turtles, MobType.TURTLE, "turtle" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareTurtles, MobType.TURTLE, "rare_turtle" + i);
        }
        for (i = 1; i <= 7; ++i) {
            this.addCustomTextures(cows, MobType.COW, "cow" + i);
        }
        for (i = 1; i <= 4; ++i) {
            this.addCustomTextures(wanderingTraders, MobType.WANDERING_TRADER, "wandering_trader" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareCows, MobType.COW, "rare_cow" + i);
        }
        for (i = 1; i <= 4; ++i) {
            this.addCustomTextures(pigs, MobType.PIG, "pig" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addCustomTextures(rarePigs, MobType.PIG, "rare_pig" + i);
        }
        for (i = 1; i <= 5; ++i) {
            this.addCustomTextures(snowGolems, MobType.SNOW_GOLEM, "snow_golem" + i);
        }
        for (i = 1; i <= 4; ++i) {
            this.addCustomTextures(squids, MobType.SQUID, "squid" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareSquids, MobType.SQUID, "rare_squid" + i);
        }
        for (i = 1; i <= 25; ++i) {
            this.addCustomTextures(wolves, MobType.WOLF, "nlg_wolf" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareWolves, MobType.WOLF, "rare_wolf" + i);
        }
        this.addCustomTextures(wolves, MobType.WOLF, "brownwolf", "greywolf", "blackwolf", "amotwolf", "jupiter1390");
        for (class_1767 color : class_1767.values()) {
            class_2960 res = this.createResource(MobType.SHEEP, "sheep_" + color.toString());
            sheep.put(color, res);
        }
    }

    public void addCustomTextures(List<class_2960> set, MobType type, String ... names) {
        ArrayList<String> textures = new ArrayList<String>(Arrays.asList(names));
        textures.forEach(texture -> {
            class_2960 res = this.createResource(type, (String)texture);
            set.add(res);
            if (type == MobType.WOLF) {
                wolvesTame.put(res, this.createResource(type, texture + "_tame"));
                wolvesAngry.put(res, this.createResource(type, texture + "_angry"));
            }
        });
    }

    @Nullable
    public static class_2960 getChickenTexture(class_1428 entity) {
        return VariantMobTexturesClient.getRandomTexture((class_1297)entity, chickens, rareChickens);
    }

    @Nullable
    public static class_2960 getCowTexture(class_1430 entity) {
        return VariantMobTexturesClient.getRandomTexture((class_1297)entity, cows, rareCows);
    }

    @Nullable
    public static class_2960 getDolphinTexture(class_1433 entity) {
        return VariantMobTexturesClient.getRandomTexture((class_1297)entity, dolphins, rareDolphins);
    }

    @Nullable
    public static class_2960 getPigTexture(class_1452 entity) {
        return VariantMobTexturesClient.getRandomTexture((class_1297)entity, pigs, rarePigs);
    }

    public static class_2960 getSheepTexture(class_1472 entity) {
        class_1767 fleeceColor = entity.method_6633();
        return sheep.getOrDefault(fleeceColor, DEFAULT_SHEEP);
    }

    @Nullable
    public static class_2960 getSnowGolemTexture(class_1473 entity) {
        return VariantMobTexturesClient.getRandomTexture((class_1297)entity, snowGolems, (List<class_2960>)ImmutableList.of());
    }

    @Nullable
    public static class_2960 getWanderingTraderTexture(class_3989 entity) {
        return VariantMobTexturesClient.getRandomTexture((class_1297)entity, wanderingTraders, (List<class_2960>)ImmutableList.of());
    }

    @Nullable
    public static class_2960 getSquidTexture(class_1477 entity) {
        return VariantMobTexturesClient.getRandomTexture((class_1297)entity, squids, rareSquids);
    }

    @Nullable
    public static class_2960 getTurtleTexture(class_1481 entity) {
        return VariantMobTexturesClient.getRandomTexture((class_1297)entity, turtles, rareTurtles);
    }

    @Nullable
    public static class_2960 getWolfTexture(class_1493 entity) {
        class_2960 res = VariantMobTexturesClient.getRandomTexture((class_1297)entity, wolves, rareWolves);
        if (res == null) {
            return null;
        }
        if (entity.method_6181()) {
            res = wolvesTame.get(res);
        } else if (entity.method_29923(entity.field_6002)) {
            res = wolvesAngry.get(res);
        }
        return res;
    }

    @Nullable
    public static class_2960 getRandomTexture(class_1297 entity, List<class_2960> normalSet, List<class_2960> rareSet) {
        List<class_2960> set;
        UUID id = entity.method_5667();
        boolean isRare = VariantMobTextures.rareVariants && !rareSet.isEmpty() && (id.getLeastSignificantBits() + id.getMostSignificantBits()) % (long)VariantMobTextures.rarity == 0L;
        List<class_2960> list = set = isRare ? rareSet : normalSet;
        if (set.isEmpty()) {
            return null;
        }
        int choice = Math.abs((int)(id.getMostSignificantBits() % (long)set.size()));
        return set.get(choice);
    }

    private class_2960 createResource(MobType type, String texture) {
        return new class_2960("charm", PREFIX + type.method_15434() + "/" + texture + ".png");
    }

    public static enum MobType implements ICharmEnum
    {
        WOLF,
        COW,
        PIG,
        CHICKEN,
        SQUID,
        SHEEP,
        WANDERING_TRADER,
        TURTLE,
        SNOW_GOLEM,
        DOLPHIN;

    }
}

