/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.handler;

import com.google.gson.JsonElement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.StringHelper;

public class RecipeHandler {
    public static void filter(Map<ResourceLocation, JsonElement> recipes) {
        Map<String, CharmModule> loadedModules = ModuleHandler.getLoadedModules();
        for (String modId : loadedModules.keySet()) {
            loadedModules.values().stream().filter(m -> m.enabled && !m.getRecipesToRemove().isEmpty()).forEach(m -> m.getRecipesToRemove().forEach(recipes::remove));
            List<ResourceLocation> modRecipes = recipes.keySet().stream().filter(r -> r.func_110624_b().equals(modId)).collect(Collectors.toList());
            modRecipes.forEach(recipeId -> {
                String path = recipeId.func_110623_a();
                if (!path.contains("/")) {
                    return;
                }
                String moduleId = StringHelper.snakeToUpperCamel(path.split("/")[0]);
                if (loadedModules.containsKey(moduleId) && !((CharmModule)loadedModules.get((Object)moduleId)).enabled) {
                    recipes.remove(recipeId);
                }
            });
        }
    }

    public static Iterator<Map.Entry<ResourceLocation, JsonElement>> sortedRecipes(Map<ResourceLocation, JsonElement> recipes) {
        return Stream.concat(recipes.entrySet().stream().filter(r -> !((ResourceLocation)r.getKey()).func_110624_b().equals("minecraft")), recipes.entrySet().stream().filter(r -> ((ResourceLocation)r.getKey()).func_110624_b().equals("minecraft"))).iterator();
    }
}

