/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;

public abstract class BaseStructure {
    private final String modId;
    private final String mainFolder;
    private final String structureName;
    private final List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> starts = new ArrayList<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>>();

    public BaseStructure(String modId, String mainFolder, String structureName) {
        this.modId = modId;
        this.mainFolder = mainFolder;
        this.structureName = structureName;
    }

    public List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> getStarts() {
        return this.starts;
    }

    protected void addStart(String pieceName, int weight) {
        this.starts.add((Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>)Pair.of((Object)JigsawPiece.func_242861_b((String)this.getPiecePath(pieceName), (StructureProcessorList)ProcessorLists.field_244101_a), (Object)weight));
    }

    protected void registerPool(String poolName, Map<String, Integer> elements, JigsawPattern.PlacementBehaviour projection) {
        ArrayList pieces = new ArrayList();
        elements.forEach((piece, weight) -> pieces.add(Pair.of((Object)JigsawPiece.func_242861_b((String)this.getPiecePath((String)piece), (StructureProcessorList)ProcessorLists.field_244101_a), (Object)weight)));
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(this.getPoolPath(poolName), this.getPoolPath("ends"), (List)ImmutableList.copyOf(pieces), projection));
    }

    protected void registerPool(String poolName, Map<String, Integer> elements) {
        this.registerPool(poolName, elements, JigsawPattern.PlacementBehaviour.RIGID);
    }

    protected String getPiecePath(String piece) {
        return this.modId + ":" + this.mainFolder + "/" + this.structureName + "/" + piece;
    }

    protected ResourceLocation getPoolPath(String pool) {
        return new ResourceLocation(this.modId, this.mainFolder + "/" + this.structureName + "/" + pool);
    }
}

