/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.block.CharmBlock;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.module.Bookcases;
import svenhjol.charm.tileentity.BookcaseTileEntity;

public class BookcaseBlock
extends CharmBlock {
    public static final IntegerProperty SLOTS = IntegerProperty.func_177719_a((String)"slots", (int)0, (int)BookcaseTileEntity.SIZE);
    protected CharmModule module;
    protected IVariantMaterial type;

    public BookcaseBlock(CharmModule module, IVariantMaterial type) {
        super(module, type.func_176610_l() + "_bookcase", AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150342_X));
        this.module = module;
        this.type = type;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)SLOTS, (Comparable)Integer.valueOf(0)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        if (!world.field_72995_K && !player.func_175149_v() && (tileEntity = world.func_175625_s(pos)) instanceof BookcaseTileEntity) {
            BookcaseTileEntity bookcase = (BookcaseTileEntity)tileEntity;
            bookcase.func_184281_d(player);
            player.func_213829_a((INamedContainerProvider)bookcase);
        }
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moved) {
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = world.func_175625_s(pos)) instanceof BookcaseTileEntity) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tile));
            world.func_175666_e(pos, (Block)this);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof BookcaseTileEntity) {
            ((BookcaseTileEntity)tile).func_213903_a(stack.func_200301_q());
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        BookcaseBlock block = (BookcaseBlock)state.func_177230_c();
        return Bookcases.BOOKCASE_BLOCKS.containsValue(block) ? 1.0f : 0.0f;
    }

    @Override
    public ItemGroup getItemGroup() {
        return ItemGroup.field_78031_c;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)SLOTS);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        BookcaseTileEntity bookcase = new BookcaseTileEntity();
        bookcase.func_213903_a((ITextComponent)new TranslationTextComponent("block." + this.module.mod + "." + this.type.func_176610_l() + "_bookcase"));
        return bookcase;
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{SLOTS});
    }
}

