/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import svenhjol.charm.base.CharmClientModule;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.CharmResources;
import svenhjol.charm.base.gui.CharmContainerScreen;
import svenhjol.charm.base.helper.ItemHelper;
import svenhjol.charm.base.helper.ItemNBTHelper;
import svenhjol.charm.block.CrateBlock;
import svenhjol.charm.handler.TooltipInventoryHandler;
import svenhjol.charm.module.Crates;
import svenhjol.charm.tileentity.CrateTileEntity;

public class CratesClient
extends CharmClientModule {
    public CratesClient(CharmModule module) {
        super(module);
    }

    @Override
    public void register() {
        ScreenManager.func_216911_a(Crates.CONTAINER, CharmContainerScreen.createFactory(1));
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        this.handleItemTooltip(event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.PostBackground event) {
        this.handleRenderTooltip(event.getMatrixStack(), event.getStack(), event.getLines(), event.getX(), event.getY());
    }

    private void handleItemTooltip(ItemStack stack, List<ITextComponent> lines) {
        if (!Crates.showTooltip) {
            return;
        }
        if (stack.func_190926_b() || ItemHelper.getBlockClass(stack) != CrateBlock.class || stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
            return;
        }
        CompoundNBT tag = ItemNBTHelper.getCompound(stack, "BlockEntityTag", true);
        if (tag != null) {
            TileEntity tile;
            if (!tag.func_150297_b("id", 8)) {
                tag = tag.func_74737_b();
                tag.func_74778_a("id", "charm:crate");
            }
            if ((tile = TileEntity.func_235657_b_(null, (CompoundNBT)tag)) != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                ArrayList<ITextComponent> toolTipCopy = new ArrayList<ITextComponent>(lines);
                for (int i = 1; i < toolTipCopy.size(); ++i) {
                    ITextComponent t = (ITextComponent)toolTipCopy.get(i);
                    String s = t.getString();
                    if (s.startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                    lines.remove(t);
                }
            }
        }
    }

    private boolean handleRenderTooltip(MatrixStack matrices, ItemStack stack, List<? extends ITextProperties> lines, int tx, int ty) {
        BlockItem blockItem;
        TileEntity tileEntity;
        Minecraft mc = Minecraft.func_71410_x();
        if (!stack.func_77942_o()) {
            return false;
        }
        CompoundNBT tag = ItemNBTHelper.getCompound(stack, "BlockEntityTag", true);
        if (tag == null) {
            return false;
        }
        if (ItemHelper.getBlockClass(stack) != CrateBlock.class) {
            return false;
        }
        if (!tag.func_150297_b("id", 8)) {
            tag = tag.func_74737_b();
            tag.func_74778_a("id", "charm:crate");
        }
        if (!((tileEntity = TileEntity.func_235657_b_((BlockState)(blockItem = (BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P(), (CompoundNBT)tag)) instanceof CrateTileEntity)) {
            return false;
        }
        CrateTileEntity crate = (CrateTileEntity)tileEntity;
        NonNullList<ItemStack> items = crate.func_190576_q();
        if (items.stream().allMatch(ItemStack::func_190926_b)) {
            return false;
        }
        int size = crate.func_70302_i_();
        int x = tx - 5;
        int y = ty - 35;
        int w = 172;
        int h = 27;
        int right = x + w;
        if (right > mc.func_228018_at_().func_198107_o()) {
            x -= right - mc.func_228018_at_().func_198107_o();
        }
        if (y < 0) {
            y = ty + lines.size() * 10 + 5;
        }
        RenderSystem.pushMatrix();
        RenderHelper.func_227780_a_();
        RenderSystem.enableRescaleNormal();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)700.0f);
        mc.func_110434_K().func_110577_a(CharmResources.SLOT_WIDGET);
        RenderHelper.func_74518_a();
        TooltipInventoryHandler.renderTooltipBackground(mc, matrices, x, y, 9, 1, -1);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer render = mc.func_175599_af();
        RenderHelper.func_227780_a_();
        RenderSystem.enableDepthTest();
        for (int i = 0; i < size; ++i) {
            ItemStack itemstack;
            try {
                itemstack = (ItemStack)items.get(i);
            }
            catch (Exception e) {
                continue;
            }
            int xp = x + 6 + i % 9 * 18;
            int yp = y + 6 + i / 9 * 18;
            if (itemstack.func_190926_b()) continue;
            render.func_180450_b(itemstack, xp, yp);
            render.func_175030_a(mc.field_71466_p, itemstack, xp, yp);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
        return true;
    }
}

