/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmClientModule;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.CharmResources;
import svenhjol.charm.base.CharmTags;
import svenhjol.charm.message.ServerOpenCrafting;
import svenhjol.charm.module.PortableCrafting;

public class PortableCraftingClient
extends CharmClientModule {
    public ImageButton craftingButton;
    public static KeyBinding keyBinding;

    public PortableCraftingClient(CharmModule module) {
        super(module);
    }

    @Override
    public void register() {
        if (PortableCrafting.enableKeybind) {
            keyBinding = new KeyBinding("key.charm.openCraftingTable", InputMappings.Type.KEYSYM, 86, "key.categories.inventory");
            ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        }
    }

    @SubscribeEvent
    public void onKeyboardKeyPressed(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (keyBinding == null || mc.field_71441_e == null || mc.field_71439_g == null || mc.field_71462_r != null) {
            return;
        }
        if (keyBinding.func_197976_a(event.getKey(), event.getScanCode())) {
            this.triggerOpenCraftingTable();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (!(event.getGui() instanceof InventoryScreen) || event.getGui() instanceof CreativeScreen) {
            return;
        }
        InventoryScreen screen = (InventoryScreen)event.getGui();
        this.craftingButton = new ImageButton(screen.getGuiLeft() + 130, screen.field_230709_l_ / 2 - 22, 20, 18, 0, 0, 19, CharmResources.INVENTORY_BUTTONS, click -> this.triggerOpenCraftingTable());
        this.craftingButton.field_230694_p_ = this.hasCrafting((PlayerEntity)mc.field_71439_g);
        event.addWidget((Widget)this.craftingButton);
    }

    @SubscribeEvent
    public void onDrawForeground(GuiContainerEvent.DrawForeground event) {
        if (!(event.getGuiContainer() instanceof InventoryScreen)) {
            return;
        }
        if (this.craftingButton == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (mc.field_71439_g.field_70170_p.func_82737_E() % 5L == 0L) {
            this.craftingButton.field_230694_p_ = this.hasCrafting((PlayerEntity)mc.field_71439_g);
        }
    }

    private boolean hasCrafting(PlayerEntity player) {
        return player.field_71071_by.func_199712_a(CharmTags.CRAFTING_TABLES);
    }

    private void triggerOpenCraftingTable() {
        Charm.PACKET_HANDLER.sendToServer(new ServerOpenCrafting());
    }

    public boolean isButtonVisible() {
        return this.craftingButton != null && this.craftingButton.field_230694_p_;
    }
}

