/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmClientModule;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.CharmResources;
import svenhjol.charm.base.helper.ItemHelper;
import svenhjol.charm.base.helper.ItemNBTHelper;
import svenhjol.charm.handler.TooltipInventoryHandler;
import svenhjol.charm.mixin.accessor.ShulkerBoxTileEntityAccessor;

public class ShulkerBoxTooltipsClient
extends CharmClientModule {
    public ShulkerBoxTooltipsClient(CharmModule module) {
        super(module);
    }

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.PostBackground event) {
        this.handleRenderTooltip(event.getMatrixStack(), event.getStack(), event.getLines(), event.getX(), event.getY());
    }

    private boolean handleRenderTooltip(MatrixStack matrices, ItemStack stack, List<? extends ITextProperties> lines, int tx, int ty) {
        BlockItem blockItem;
        TileEntity tileEntity;
        Minecraft mc = Minecraft.func_71410_x();
        if (ItemHelper.getBlockClass(stack) != ShulkerBoxBlock.class) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return false;
        }
        CompoundNBT tag = ItemNBTHelper.getCompound(stack, "BlockEntityTag", true);
        if (tag == null) {
            return false;
        }
        if (!tag.func_150297_b("id", 8)) {
            tag = tag.func_74737_b();
            tag.func_74778_a("id", "minecraft:shulker_box");
        }
        if ((tileEntity = TileEntity.func_235657_b_((BlockState)(blockItem = (BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P(), (CompoundNBT)tag)) == null) {
            return false;
        }
        ShulkerBoxTileEntity shulkerbox = (ShulkerBoxTileEntity)tileEntity;
        NonNullList<ItemStack> items = ((ShulkerBoxTileEntityAccessor)shulkerbox).getItems();
        int size = shulkerbox.func_70302_i_();
        int x = tx - 5;
        int y = ty - 35;
        int w = 172;
        int h = 27;
        int right = x + w;
        if (right > mc.func_228018_at_().func_198107_o()) {
            x -= right - mc.func_228018_at_().func_198107_o();
        }
        if (y < 0) {
            y = ty + lines.size() * 10 + 5;
        }
        RenderSystem.pushMatrix();
        RenderHelper.func_227780_a_();
        RenderSystem.enableRescaleNormal();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)700.0f);
        mc.func_110434_K().func_110577_a(CharmResources.SLOT_WIDGET);
        RenderHelper.func_74518_a();
        TooltipInventoryHandler.renderTooltipBackground(mc, matrices, x, y, 9, 3, -1);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer render = mc.func_175599_af();
        RenderHelper.func_227780_a_();
        RenderSystem.enableDepthTest();
        for (int i = 0; i < size; ++i) {
            ItemStack itemstack;
            try {
                itemstack = (ItemStack)items.get(i);
            }
            catch (Exception e) {
                continue;
            }
            int xp = x + 6 + i % 9 * 18;
            int yp = y + 6 + i / 9 * 18;
            if (itemstack.func_190926_b()) continue;
            render.func_180450_b(itemstack, xp, yp);
            render.func_175030_a(mc.field_71466_p, itemstack, xp, yp);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
        return true;
    }
}

