/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractCoralPlantBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import svenhjol.charm.Charm;
import svenhjol.charm.base.helper.ItemNBTHelper;
import svenhjol.charm.base.helper.PlayerHelper;
import svenhjol.charm.module.CoralSquids;

public class CoralSquidEntity
extends WaterMobEntity {
    public static final String CORAL_SQUID_TYPE_TAG = "CoralSquidType";
    public static final String CORAL_SQUID_FROM_BUCKET_TAG = "FromBucket";
    private static final DataParameter<Boolean> FROM_BUCKET;
    private static final DataParameter<Integer> CORAL_SQUID_TYPE;
    public static final Map<Integer, ResourceLocation> TEXTURES;
    public static final Map<Integer, Item> DROPS;
    public float tiltAngle;
    public float prevTiltAngle;
    public float rollAngle;
    public float prevRollAngle;
    public float squidRotation;
    public float prevThrustTimer;
    public float tentacleAngle;
    public float prevTentacleAngle;
    private float swimVelocityScale;
    private float thrustTimerSpeed;
    private float turningSpeed;
    private float swimX;
    private float swimY;
    private float swimZ;

    public CoralSquidEntity(EntityType<? extends CoralSquidEntity> entityType, World world) {
        super(entityType, world);
        this.field_70146_Z.setSeed(this.func_145782_y());
        this.thrustTimerSpeed = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.28f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT entityTag) {
        entityData = super.func_213386_a(world, difficulty, spawnReason, entityData, entityTag);
        this.setCoralSquidType(this.field_70146_Z.nextInt(5));
        return entityData;
    }

    public static boolean canSpawn(EntityType<CoralSquidEntity> type, IWorldReader world, SpawnReason spawnReason, BlockPos pos, Random random) {
        boolean canSpawn;
        BlockPos downPos;
        BlockState downState;
        boolean coralBelow = false;
        for (int y = 0; y > -16 && !(coralBelow = (downState = world.func_180495_p(downPos = pos.func_177982_a(0, y, 0))).func_177230_c() instanceof AbstractCoralPlantBlock); --y) {
        }
        boolean bl = canSpawn = pos.func_177956_o() > 20 && pos.func_177956_o() < world.func_181545_F() && coralBelow;
        if (canSpawn) {
            Charm.LOG.debug("Can spawn coral squid at " + pos.toString());
        }
        return canSpawn;
    }

    public int func_70641_bl() {
        return 4;
    }

    public ResourceLocation getTexture() {
        return TEXTURES.getOrDefault(this.getCoralSquidType(), TEXTURES.get(0));
    }

    public int getCoralSquidType() {
        return (Integer)this.field_70180_af.func_187225_a(CORAL_SQUID_TYPE);
    }

    public void setCoralSquidType(int type) {
        if (type < 0 || type > 4) {
            type = this.field_70146_Z.nextInt(5);
        }
        this.field_70180_af.func_187227_b(CORAL_SQUID_TYPE, (Object)type);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CORAL_SQUID_TYPE, (Object)1);
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a(CORAL_SQUID_TYPE_TAG, this.getCoralSquidType());
        tag.func_74757_a(CORAL_SQUID_FROM_BUCKET_TAG, this.isFromBucket());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setCoralSquidType(tag.func_74762_e(CORAL_SQUID_TYPE_TAG));
        this.setFromBucket(tag.func_74767_n(CORAL_SQUID_FROM_BUCKET_TAG));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FleeGoal());
    }

    protected void func_213333_a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.func_213333_a(source, lootingMultiplier, allowDrops);
        Entity attacker = source.func_76346_g();
        if (attacker instanceof PlayerEntity && (double)this.field_70146_Z.nextFloat() < CoralSquids.dropChance) {
            this.func_199703_a((IItemProvider)DROPS.get(this.getCoralSquidType()));
        }
    }

    public static AttributeModifierMap.MutableAttribute createSquidAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 5.0);
    }

    protected float func_213348_b(Pose pose, EntitySize dimensions) {
        return dimensions.field_220316_b * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return 1.0f;
    }

    protected boolean canClimb() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevTiltAngle = this.tiltAngle;
        this.prevRollAngle = this.rollAngle;
        this.prevThrustTimer = this.squidRotation;
        this.prevTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.thrustTimerSpeed;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(7) == 0) {
                    this.thrustTimerSpeed = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.func_203005_aq()) {
            if (this.squidRotation < (float)Math.PI) {
                float f = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.swimVelocityScale = 1.0f;
                    this.turningSpeed = 1.0f;
                } else {
                    this.turningSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.swimVelocityScale *= 0.9f;
                this.turningSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_213293_j(this.swimX * this.swimVelocityScale, this.swimY * this.swimVelocityScale, this.swimZ * this.swimVelocityScale);
            }
            Vector3d vec3d = this.func_213322_ci();
            float g = MathHelper.func_76133_a((double)CoralSquidEntity.func_213296_b((Vector3d)vec3d));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.rollAngle = (float)((double)this.rollAngle + Math.PI * (double)this.turningSpeed * 1.5);
            this.tiltAngle += (-((float)MathHelper.func_181159_b((double)g, (double)vec3d.field_72448_b)) * 57.295776f - this.tiltAngle) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                double d = this.func_213322_ci().field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d = 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1);
                } else if (!this.func_189652_ae()) {
                    d -= 0.08;
                }
                this.func_213293_j(0.0, d * 0.981, 0.0);
            }
            this.tiltAngle = (float)((double)this.tiltAngle + (double)(-90.0f - this.tiltAngle) * 0.02);
        }
    }

    public void func_213352_e(Vector3d movementInput) {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte status) {
        if (status == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(status);
        }
    }

    public void setSwimmingVector(float x, float y, float z) {
        this.swimX = x;
        this.swimY = y;
        this.swimZ = z;
    }

    public boolean hasSwimmingVector() {
        return this.swimX != 0.0f || this.swimY != 0.0f || this.swimZ != 0.0f;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            held.func_190918_g(1);
            ItemStack coralSquidBucket = new ItemStack((IItemProvider)CoralSquids.CORAL_SQUID_BUCKET);
            ItemNBTHelper.setCompound(coralSquidBucket, "stored_coral_squid", this.serializeNBT());
            if (this.func_145818_k_()) {
                coralSquidBucket.func_200302_a(this.func_200201_e());
            }
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, coralSquidBucket);
            }
            PlayerHelper.addOrDropStack(player, coralSquidBucket);
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean fromBucket) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)fromBucket);
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.isFromBucket();
    }

    public boolean func_213397_c(double distanceSquared) {
        return !this.isFromBucket() && !this.func_145818_k_();
    }

    static {
        CORAL_SQUID_TYPE = EntityDataManager.func_187226_a(CoralSquidEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        FROM_BUCKET = EntityDataManager.func_187226_a(CoralSquidEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
        TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), map -> {
            map.put(0, new ResourceLocation("charm", "textures/entity/coral_squid/tube.png"));
            map.put(1, new ResourceLocation("charm", "textures/entity/coral_squid/brain.png"));
            map.put(2, new ResourceLocation("charm", "textures/entity/coral_squid/bubble.png"));
            map.put(3, new ResourceLocation("charm", "textures/entity/coral_squid/fire.png"));
            map.put(4, new ResourceLocation("charm", "textures/entity/coral_squid/horn.png"));
        });
        DROPS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), map -> {
            map.put(0, Items.field_221965_hO);
            map.put(1, Items.field_221967_hP);
            map.put(2, Items.field_221969_hQ);
            map.put(3, Items.field_221971_hR);
            map.put(4, Items.field_221973_hS);
        });
    }

    static class SwimGoal
    extends Goal {
        private final CoralSquidEntity squid;

        public SwimGoal(CoralSquidEntity squid) {
            this.squid = squid;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.squid.func_70654_ax();
            if (i > 100) {
                this.squid.setSwimmingVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.func_70681_au().nextInt(50) == 0 || !this.squid.field_70171_ac || !this.squid.hasSwimmingVector()) {
                float f = this.squid.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float g = MathHelper.func_76134_b((float)f) * 0.2f;
                float h = -0.1f + this.squid.func_70681_au().nextFloat() * 0.2f;
                float j = MathHelper.func_76126_a((float)f) * 0.2f;
                this.squid.setSwimmingVector(g, h, j);
            }
        }
    }

    class FleeGoal
    extends Goal {
        private int timer;

        private FleeGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity livingEntity = CoralSquidEntity.this.func_70643_av();
            if (CoralSquidEntity.this.func_70090_H() && livingEntity != null) {
                return CoralSquidEntity.this.func_70068_e((Entity)livingEntity) < 100.0;
            }
            return false;
        }

        public void func_75249_e() {
            this.timer = 0;
        }

        public void func_75246_d() {
            ++this.timer;
            LivingEntity livingEntity = CoralSquidEntity.this.func_70643_av();
            if (livingEntity != null) {
                Vector3d vec3d = new Vector3d(CoralSquidEntity.this.func_226277_ct_() - livingEntity.func_226277_ct_(), CoralSquidEntity.this.func_226278_cu_() - livingEntity.func_226278_cu_(), CoralSquidEntity.this.func_226281_cx_() - livingEntity.func_226281_cx_());
                BlockState blockState = CoralSquidEntity.this.field_70170_p.func_180495_p(new BlockPos(CoralSquidEntity.this.func_226277_ct_() + vec3d.field_72450_a, CoralSquidEntity.this.func_226278_cu_() + vec3d.field_72448_b, CoralSquidEntity.this.func_226281_cx_() + vec3d.field_72449_c));
                FluidState fluidState = CoralSquidEntity.this.field_70170_p.func_204610_c(new BlockPos(CoralSquidEntity.this.func_226277_ct_() + vec3d.field_72450_a, CoralSquidEntity.this.func_226278_cu_() + vec3d.field_72448_b, CoralSquidEntity.this.func_226281_cx_() + vec3d.field_72449_c));
                if (fluidState.func_206884_a((ITag)FluidTags.field_206959_a) || blockState.func_196958_f()) {
                    double d = vec3d.func_72433_c();
                    if (d > 0.0) {
                        vec3d.func_72432_b();
                        float f = 3.0f;
                        if (d > 5.0) {
                            f = (float)((double)f - (d - 5.0) / 5.0);
                        }
                        if (f > 0.0f) {
                            vec3d = vec3d.func_186678_a((double)f);
                        }
                    }
                    if (blockState.func_196958_f()) {
                        vec3d = vec3d.func_178786_a(0.0, vec3d.field_72448_b, 0.0);
                    }
                    CoralSquidEntity.this.setSwimmingVector((float)vec3d.field_72450_a / 20.0f, (float)vec3d.field_72448_b / 20.0f, (float)vec3d.field_72449_c / 20.0f);
                }
                if (this.timer % 10 == 5) {
                    CoralSquidEntity.this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, CoralSquidEntity.this.func_226277_ct_(), CoralSquidEntity.this.func_226278_cu_(), CoralSquidEntity.this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

