/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.handler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryTidyingHandler {
    public static final int BE = 0;
    public static final int PLAYER = 1;
    private static final Map<Predicate<ItemStack>, Comparator<ItemStack>> testCompare = new HashMap<Predicate<ItemStack>, Comparator<ItemStack>>();

    public static void init() {
        testCompare.clear();
        testCompare.put(InventoryTidyingHandler.clazzTest(BlockItem.class).negate(), InventoryTidyingHandler.anyCompare());
        testCompare.put(InventoryTidyingHandler.clazzTest(BlockItem.class), InventoryTidyingHandler.blockCompare());
    }

    public static void sort(IInventory inventory, int startSlot, int endSlot) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        InventoryTidyingHandler.populate(inventory, stacks, startSlot, endSlot);
        InventoryTidyingHandler.mergeInventory(stacks);
        InventoryTidyingHandler.sortInventory(stacks);
        InventoryTidyingHandler.setInventory(inventory, stacks, startSlot, endSlot);
    }

    public static void populate(IInventory inventory, List<ItemStack> stacks, int startSlot, int endSlot) {
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            stacks.add(stackInSlot.func_77946_l());
        }
    }

    public static void mergeInventory(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack2 = stacks.get(i);
            if (stack2.func_190926_b()) continue;
            for (int j = 0; j < stacks.size(); ++j) {
                ItemStack stack1;
                if (i == j || (stack1 = stacks.get(j)).func_190926_b() || stack1.func_190916_E() >= stack1.func_77976_d() || !ItemStack.func_179545_c((ItemStack)stack2, (ItemStack)stack1) || !ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1)) continue;
                int setSize = stack1.func_190916_E() + stack2.func_190916_E();
                int carryover = Math.max(0, setSize - stack1.func_77976_d());
                stack1.func_190920_e(carryover);
                stack2.func_190920_e(setSize - carryover);
                if (stack2.func_190916_E() == stack2.func_77976_d()) break;
            }
            stacks.set(i, stack2);
        }
        stacks.removeIf(stack -> stack.func_190926_b() || stack.func_190916_E() == 0);
    }

    public static void sortInventory(List<ItemStack> stacks) {
        stacks.sort(InventoryTidyingHandler::compare);
    }

    private static boolean setInventory(IInventory inventory, List<ItemStack> stacks, int startSlot, int endSlot) {
        for (int i = startSlot; i < endSlot; ++i) {
            int j = i - startSlot;
            ItemStack stack = j >= stacks.size() ? ItemStack.field_190927_a : stacks.get(j);
            inventory.func_70298_a(i, inventory.func_70297_j_());
            if (stack.func_190926_b()) continue;
            inventory.func_70299_a(i, stack);
        }
        return true;
    }

    private static int compare(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1.func_190926_b()) {
            return -1;
        }
        if (stack2.func_190926_b()) {
            return 1;
        }
        int index1 = 1;
        int index2 = -1;
        int index = 0;
        for (Predicate<ItemStack> predicate : testCompare.keySet()) {
            if (predicate.test(stack1)) {
                index1 = index;
            }
            if (predicate.test(stack2)) {
                index2 = index;
            }
            if (index1 >= 0 && index1 == index2) {
                return testCompare.get(predicate).compare(stack1, stack2);
            }
            ++index;
        }
        return index1 - index2;
    }

    private static Comparator<ItemStack> blockCompare() {
        return InventoryTidyingHandler.compare(Comparator.comparing(s -> Item.func_150891_b((Item)s.func_77973_b())), (s1, s2) -> s2.func_190916_E() - s1.func_190916_E(), (s1, s2) -> s2.hashCode() - s1.hashCode());
    }

    private static Comparator<ItemStack> anyCompare() {
        return InventoryTidyingHandler.compare(Comparator.comparing(s -> Item.func_150891_b((Item)s.func_77973_b())), (s1, s2) -> s2.func_190916_E() - s1.func_190916_E(), (s1, s2) -> s2.hashCode() - s1.hashCode());
    }

    @SafeVarargs
    private static Comparator<ItemStack> compare(Comparator<ItemStack> ... comparators) {
        return (stack1, stack2) -> {
            for (Comparator comparator : comparators) {
                int res = comparator.compare(stack1, stack2);
                if (res == 0) continue;
                return res;
            }
            return 0;
        };
    }

    private static Predicate<ItemStack> clazzTest(Class<? extends Item> clazz) {
        return stack -> !stack.func_190926_b() && clazz.isInstance(stack.func_77973_b());
    }
}

