/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.mixin;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.module.ArmorInvisibility;
import svenhjol.charm.module.UseTotemFromInventory;
import svenhjol.charm.module.VariantLadders;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> type, World world) {
        super(type, world);
    }

    @Shadow
    public abstract Iterable<ItemStack> func_184193_aE();

    @Redirect(method={"checkTotemDeathProtection"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getHeldItem(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;"))
    private ItemStack hookTryUseTotem(LivingEntity livingEntity, Hand hand) {
        return UseTotemFromInventory.tryFromInventory(livingEntity, hand);
    }

    @Inject(method={"getArmorCoverPercentage"}, at={@At(value="HEAD")}, cancellable=true)
    private void hookArmorCover(CallbackInfoReturnable<Float> cir) {
        if (ModuleHandler.enabled(ArmorInvisibility.class)) {
            LivingEntity entity = (LivingEntity)this;
            Iterable<ItemStack> armorItems = this.func_184193_aE();
            int i = 0;
            int j = 0;
            for (ItemStack itemstack : armorItems) {
                if (!ArmorInvisibility.shouldArmorBeInvisible((Entity)entity, itemstack)) {
                    ++j;
                }
                ++i;
            }
            cir.setReturnValue((Object)Float.valueOf(i > 0 ? (float)j / (float)i : 0.0f));
        }
    }

    @Inject(method={"canGoThroughtTrapDoorOnLadder"}, at={@At(value="HEAD")}, cancellable=true)
    private void hookCanEnterTrapdoor(BlockPos pos, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (VariantLadders.canEnterTrapdoor(this.field_70170_p, pos, state)) {
            cir.setReturnValue((Object)true);
        }
    }
}

