/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", description="Removes minimum and maximum XP costs on the anvil. Anvils are also less likely to break.")
public class AnvilImprovements
extends CharmModule {
    @Config(name="Remove Too Expensive", description="If true, removes the maximum cost of 40 XP when working items on the anvil.")
    public static boolean removeTooExpensive = true;
    @Config(name="Stronger anvils", description="If true, anvils are 50% less likely to take damage when used.")
    public static boolean strongerAnvils = true;
    @Config(name="Allow higher enchantment levels", description="If true, an enchanted book with a level higher than the maximum enchantment level may be applied to an item.")
    public static boolean higherEnchantmentLevels = true;
    @Config(name="Show item repair cost", description="If true, items show their repair cost in their tooltip when looking at the anvil screen.")
    public static boolean showRepairCost = true;

    public static boolean allowTooExpensive() {
        return ModuleHandler.enabled(AnvilImprovements.class) && removeTooExpensive;
    }

    public static boolean allowTakeWithoutXp(PlayerEntity player, IntReferenceHolder levelCost) {
        return ModuleHandler.enabled(AnvilImprovements.class) && (player.field_71075_bZ.field_75098_d || player.field_71068_ca >= levelCost.func_221495_b() && levelCost.func_221495_b() > -1);
    }

    public static void setEnchantmentsAllowHighLevel(Map<Enchantment, Integer> enchantments, ItemStack book, ItemStack output) {
        if (book.func_190926_b() || output.func_190926_b()) {
            return;
        }
        if (ModuleHandler.enabled(AnvilImprovements.class) && book.func_77973_b() instanceof EnchantedBookItem) {
            HashMap<Enchantment, Integer> reset = new HashMap<Enchantment, Integer>();
            Map bookEnchants = EnchantmentHelper.func_82781_a((ItemStack)book);
            bookEnchants.forEach((e, l) -> {
                if (l > e.func_77325_b()) {
                    reset.put((Enchantment)e, (Integer)l);
                }
            });
            reset.forEach((e, l) -> {
                if (enchantments.containsKey(e)) {
                    enchantments.put((Enchantment)e, (Integer)l);
                }
            });
        }
        EnchantmentHelper.func_82782_a(enchantments, (ItemStack)output);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean tryDamageAnvil() {
        if (!ModuleHandler.enabled(AnvilImprovements.class)) return false;
        if (!strongerAnvils) return false;
        Random random = new Random();
        if (!(random.nextFloat() < 0.5f)) return false;
        return true;
    }

    public static List<ITextComponent> addRepairCostToTooltip(ItemStack stack, List<ITextComponent> tooltip) {
        int repairCost = stack.func_82838_A();
        if (repairCost > 0) {
            tooltip.add(StringTextComponent.field_240750_d_);
            tooltip.add((ITextComponent)new TranslationTextComponent("item.charm.repair_cost", new Object[]{repairCost}).func_240699_a_(TextFormatting.GRAY));
        }
        return tooltip;
    }
}

