/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.base.enums.VanillaVariantMaterial;
import svenhjol.charm.base.handler.RegistryHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.block.BookcaseBlock;
import svenhjol.charm.client.BookcasesClient;
import svenhjol.charm.container.BookcaseContainer;
import svenhjol.charm.module.Atlas;
import svenhjol.charm.tileentity.BookcaseTileEntity;

@Module(mod="charm", client=BookcasesClient.class, description="Bookshelves that can hold up to 9 stacks of books and maps.")
public class Bookcases
extends CharmModule {
    public static final ResourceLocation ID = new ResourceLocation("charm", "bookcase");
    public static final Map<IVariantMaterial, BookcaseBlock> BOOKCASE_BLOCKS = new HashMap<IVariantMaterial, BookcaseBlock>();
    public static ContainerType<BookcaseContainer> CONTAINER;
    public static TileEntityType<BookcaseTileEntity> TILE_ENTITY;
    public static List<Item> validItems;
    @Config(name="Valid books", description="Additional items that may be placed in bookcases.")
    public static List<String> configValidItems;

    @Override
    public void register() {
        VanillaVariantMaterial.getTypes().forEach(type -> BOOKCASE_BLOCKS.put((IVariantMaterial)type, new BookcaseBlock(this, (IVariantMaterial)type)));
        CONTAINER = RegistryHandler.container(ID, BookcaseContainer::new);
        TILE_ENTITY = RegistryHandler.tileEntity(ID, BookcaseTileEntity::new, new Block[0]);
    }

    @Override
    public void onCommonSetup(FMLCommonSetupEvent event) {
        validItems.addAll(Arrays.asList(Items.field_151122_aG, Items.field_151134_bR, Items.field_151164_bB, Items.field_151099_bA, Items.field_192397_db, Items.field_151121_aF, Items.field_151148_bJ, Items.field_151098_aY, Atlas.ATLAS_ITEM));
        configValidItems.forEach(string -> {
            Item item = (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation(string));
            validItems.add(item);
        });
    }

    public static boolean canContainItem(ItemStack stack) {
        return validItems.contains(stack.func_77973_b());
    }

    static {
        validItems = new ArrayList<Item>();
        configValidItems = new ArrayList<String>();
    }
}

