/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.ItemHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;

@Module(mod="charm", description="Husks spawn anywhere within their biome and have a chance to drop sand.", hasSubscriptions=true)
public class HuskImprovements
extends CharmModule {
    public static double lootingBoost = 0.3;
    @Config(name="Spawn anywhere in biome", description="If true, husks can spawn anywhere within their biome rather than just the surface.")
    public static boolean spawnAnywhere = true;
    @Config(name="Drop sand when killed", description="If true, husks drop sand when killed.")
    public static boolean dropSand = true;
    @Config(name="Maximum drops", description="Maximum sand dropped when husk is killed.")
    public static int maxDrops = 2;

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled()) {
            this.tryDrop((Entity)event.getEntityLiving(), event.getSource(), event.getLootingLevel());
        }
    }

    public static boolean canSpawn() {
        return ModuleHandler.enabled(HuskImprovements.class) && spawnAnywhere;
    }

    private void tryDrop(Entity entity, DamageSource source, int lootingLevel) {
        if (dropSand && !entity.field_70170_p.field_72995_K && entity instanceof HuskEntity) {
            World world = entity.func_130014_f_();
            BlockPos pos = entity.func_233580_cy_();
            int amount = ItemHelper.getAmountWithLooting(world.field_73012_v, maxDrops, lootingLevel, (float)lootingBoost);
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Blocks.field_150354_m, amount)));
        }
    }
}

