/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.mixin.accessor.PlayerEntityAccessor;

@Module(mod="charm", description="Parrots stay on your shoulder when jumping and falling. Crouch to make them dismount.", hasSubscriptions=true)
public class ParrotsStayOnShoulder
extends CharmModule {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.isCanceled()) {
            this.tryDismountParrot(event.player);
        }
    }

    public static boolean shouldParrotStayMounted(World world, long shoulderTime) {
        return shoulderTime + 20L < world.func_82737_E() && ModuleHandler.enabled(ParrotsStayOnShoulder.class);
    }

    public void tryDismountParrot(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 10L == 0L && player.func_225608_bj_()) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (!serverPlayer.func_192023_dk().isEmpty()) {
                ((PlayerEntityAccessor)serverPlayer).invokeSpawnShoulderEntity(serverPlayer.func_192023_dk());
                ((PlayerEntityAccessor)serverPlayer).invokeSetLeftShoulderEntity(new CompoundNBT());
            }
            if (!serverPlayer.func_192025_dl().isEmpty()) {
                ((PlayerEntityAccessor)serverPlayer).invokeSpawnShoulderEntity(serverPlayer.func_192025_dl());
                ((PlayerEntityAccessor)serverPlayer).invokeSetRightShoulderEntity(new CompoundNBT());
            }
        }
    }
}

