/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.SnowStormsClient;

@Module(mod="charm", client=SnowStormsClient.class, description="Increases snow layers in cold biomes during thunderstorms.")
public class SnowStorms
extends CharmModule {
    public static final ResourceLocation HEAVY_SNOW = new ResourceLocation("charm", "textures/environment/heavy_snow.png");
    @Config(name="Snow layer chance", description="Chance (out of 1.0) every tick of snow increasing by one layer during a thunderstorm.")
    public static double snowLayerChance = 0.15;
    @Config(name="Heavier snow texture", description="If true, heavier snow textures are rendered during thunderstorms.")
    public static boolean heavierSnowTexture = true;

    public static boolean tryRandomTick(ServerWorld world) {
        return ModuleHandler.enabled(SnowStorms.class) && world.func_72911_I();
    }

    public static void tryPlaceSnow(ServerWorld world, int chunkX, int chunkZ) {
        if (!ModuleHandler.enabled(SnowStorms.class) || !world.func_72911_I()) {
            return;
        }
        if (world.field_73012_v.nextDouble() < snowLayerChance) {
            BlockPos pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(chunkX, 0, chunkZ, 15));
            BlockPos downPos = pos.func_177977_b();
            BlockState downState = world.func_180495_p(downPos);
            Biome biome = world.func_226691_t_(pos);
            if (biome.func_225486_c(pos) < 0.15f && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
                int layers;
                BlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (!(!state.func_196958_f() || downState.func_203425_a(Blocks.field_150432_aD) || downState.func_203425_a(Blocks.field_150403_cj) || downState.func_203425_a(Blocks.field_180401_cv) || downState.func_203425_a(Blocks.field_226907_mc_) || downState.func_203425_a(Blocks.field_150425_aM) || downState.func_203425_a(Blocks.field_150433_aE) || !Block.func_208061_a((VoxelShape)downState.func_196952_d((IBlockReader)world, downPos), (Direction)Direction.UP))) {
                    world.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
                    return;
                }
                if (block == Blocks.field_150433_aE && (layers = ((Integer)state.func_177229_b((Property)SnowBlock.field_176315_a)).intValue()) < 8) {
                    state = (BlockState)state.func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(++layers));
                    world.func_175656_a(pos, state);
                }
            }
        }
    }
}

