/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import svenhjol.charm.base.helper.MapRenderHelper;
import svenhjol.charm.container.AtlasInventory;
import svenhjol.charm.module.Atlas;

public class AtlasRenderer {
    public final RenderType ATLAS_BACKGROUND = RenderType.func_228658_l_((ResourceLocation)new ResourceLocation("charm", "textures/map/atlas_background.png"));
    private final MapItemRenderer mapItemRenderer;
    private final EntityRendererManager renderManager;
    private final TextureManager textureManager;

    public AtlasRenderer() {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.mapItemRenderer = minecraft.field_71460_t.func_147701_i();
        this.renderManager = minecraft.func_175598_ae();
        this.textureManager = minecraft.func_110434_K();
    }

    public void renderAtlas(MatrixStack matrixStack, IRenderTypeBuffer buffers, int light, Hand hand, float equip, float swing, ItemStack stack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientWorld world = minecraft.field_71441_e;
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        AtlasInventory inventory = Atlas.getInventory((World)world, stack);
        matrixStack.func_227860_a_();
        HandSide handSide = hand == Hand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        float e = handSide == HandSide.RIGHT ? 1.0f : -1.0f;
        matrixStack.func_227861_a_((double)(e * 0.125f), -0.125, 0.0);
        if (!player.func_82150_aj()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(e * 10.0f));
            this.renderArm(player, matrixStack, buffers, light, equip, swing, handSide);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        this.transformPageForHand(matrixStack, swing, equip, handSide);
        this.renderAtlasMap(inventory.getActiveMap((World)world), matrixStack, buffers, light);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    public void renderArm(ClientPlayerEntity player, MatrixStack matrices, IRenderTypeBuffer buffer, int light, float equip, float swing, HandSide side) {
        boolean flag = side != HandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)swing);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(swing * (float)Math.PI));
        matrices.func_227861_a_((double)(f * (f2 + 0.64000005f)), (double)(f3 + -0.6f + equip * -0.6f), (double)(f4 + -0.71999997f));
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * 45.0f));
        float f5 = MathHelper.func_76126_a((float)(swing * swing * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * f6 * 70.0f));
        matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * f5 * -20.0f));
        this.textureManager.func_110577_a(player.func_110306_p());
        matrices.func_227861_a_((double)(f * -1.0f), (double)3.6f, 3.5);
        matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * 120.0f));
        matrices.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(200.0f));
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f * -135.0f));
        matrices.func_227861_a_((double)(f * 5.6f), 0.0, 0.0);
        PlayerRenderer playerrenderer = (PlayerRenderer)this.renderManager.func_78713_a((Entity)player);
        if (flag) {
            playerrenderer.func_229144_a_(matrices, buffer, light, (AbstractClientPlayerEntity)player);
        } else {
            playerrenderer.func_229146_b_(matrices, buffer, light, (AbstractClientPlayerEntity)player);
        }
    }

    public void transformPageForHand(MatrixStack matrixStack, float swing, float equip, HandSide handSide) {
        float e = handSide == HandSide.RIGHT ? 1.0f : -1.0f;
        matrixStack.func_227861_a_((double)(e * 0.51f), (double)(-0.08f + equip * -1.2f), -0.75);
        float f1 = MathHelper.func_76129_c((float)swing);
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * MathHelper.func_76126_a((float)(swing * (float)Math.PI));
        matrixStack.func_227861_a_((double)(e * f3), (double)(f4 - 0.3f * f2), (double)f5);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * -45.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(e * f2 * -30.0f));
    }

    public void renderAtlasMap(MapData mapData, MatrixStack matrixStack, IRenderTypeBuffer buffers, int light) {
        this.renderBackground(this.ATLAS_BACKGROUND, matrixStack, buffers, light);
        if (mapData != null) {
            matrixStack.func_227860_a_();
            this.mapItemRenderer.func_228086_a_(matrixStack, buffers, mapData, false, light);
            matrixStack.func_227865_b_();
        }
    }

    private void renderBackground(RenderType background, MatrixStack matrixStack, IRenderTypeBuffer buffers, int light) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227862_a_(0.38f, 0.38f, 0.38f);
        matrixStack.func_227861_a_(-0.5, -0.5, 0.0);
        matrixStack.func_227862_a_(0.0078125f, 0.0078125f, 0.0078125f);
        MapRenderHelper.drawBackgroundVertex(matrixStack, light, buffers.getBuffer(background));
    }
}

