/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.cereal.spec;

import com.terraforged.cereal.Cereal;
import com.terraforged.cereal.spec.Context;
import com.terraforged.cereal.spec.DataFactory;
import com.terraforged.cereal.spec.DefaultData;
import com.terraforged.cereal.value.DataList;
import com.terraforged.cereal.value.DataObject;
import com.terraforged.cereal.value.DataValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class DataSpec<T> {
    private final String name;
    private final Class<T> type;
    private final DataFactory<T> constructor;
    private final Map<String, DefaultData> defaults;
    private final Map<String, Function<T, ?>> accessors;

    public DataSpec(Builder<T> builder) {
        this.name = ((Builder)builder).name;
        this.type = ((Builder)builder).type;
        this.constructor = ((Builder)builder).constructor;
        this.defaults = Collections.unmodifiableMap(((Builder)builder).defaults);
        this.accessors = Collections.unmodifiableMap(((Builder)builder).accessors);
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public <V> V get(String key, DataObject holder, Function<DataValue, V> accessor) {
        return accessor.apply(this.getValue(key, holder));
    }

    public <V> V get(String key, DataObject holder, Class<V> type) {
        return this.get(key, holder, type, Context.NONE);
    }

    public <V> V get(String key, DataObject holder, Class<V> type, Context context) {
        DataObject value = holder.get(key).asObj();
        return Cereal.deserialize(value, type, context);
    }

    public DataValue serialize(Object value) {
        return this.serialize(value, Context.NONE);
    }

    public DataValue serialize(Object value, Context context) {
        if (this.getType().isInstance(value)) {
            boolean skipDefaults = context.skipDefaults();
            T t = this.getType().cast(value);
            DataObject root = new DataObject(this.name);
            for (Map.Entry<String, Function<T, ?>> e : this.accessors.entrySet()) {
                Object o = e.getValue().apply(t);
                DataValue val = DataValue.of(o);
                if (skipDefaults && val.equals(this.getDefault(e.getKey()))) continue;
                root.add(e.getKey(), val);
            }
            return root;
        }
        return DataValue.NULL;
    }

    public T deserialize(DataObject data) {
        return this.deserialize(data, Context.NONE);
    }

    public <V> V deserialize(DataObject data, Class<V> type) {
        return this.deserialize(data, type, Context.NONE);
    }

    public T deserialize(DataObject data, Context context) {
        return this.constructor.create(data, this, context);
    }

    public <V> V deserialize(DataObject data, Class<V> type, Context context) {
        if (type.isAssignableFrom(this.getType())) {
            T t = this.deserialize(data, context);
            if (type.isInstance(t)) {
                return type.cast(t);
            }
            throw new RuntimeException("Invalid type: " + type + " for instance: " + t.getClass());
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public Map<String, DefaultData> getDefaults() {
        return this.defaults;
    }

    private DataValue getValue(String key, DataObject holder) {
        DataValue value = holder.get(key);
        if (value.isNonNull()) {
            return value;
        }
        return this.getDefault(key);
    }

    private DataValue getDefault(String name) {
        DefaultData data = this.defaults.get(name);
        if (data.hasValue()) {
            return data.getValue();
        }
        return DataValue.NULL;
    }

    public static <T> Builder<T> builder(Class<T> type, DataFactory<T> constructor) {
        return DataSpec.builder(type.getSimpleName(), type, constructor);
    }

    public static <T> Builder<T> builder(String name, Class<T> type, DataFactory<T> constructor) {
        return new Builder<T>(name, type, constructor);
    }

    public static class Builder<T> {
        private final String name;
        private final Class<T> type;
        private final DataFactory<T> constructor;
        private final Map<String, DefaultData> defaults = new LinkedHashMap<String, DefaultData>();
        private final Map<String, Function<T, ?>> accessors = new LinkedHashMap();

        public Builder(String name, Class<T> type, DataFactory<T> constructor) {
            this.name = name;
            this.type = type;
            this.constructor = constructor;
        }

        public <V> Builder<T> add(String key, Object value, Function<T, V> accessor) {
            this.accessors.put(key, accessor);
            this.defaults.put(key, new DefaultData(DataValue.lazy(value)));
            return this;
        }

        public <V> Builder<T> add(String key, DataValue value, Function<T, V> accessor) {
            this.accessors.put(key, accessor);
            this.defaults.put(key, new DefaultData(value));
            return this;
        }

        public <V> Builder<T> addObj(String key, Function<T, V> accessor) {
            this.accessors.put(key, accessor);
            this.defaults.put(key, new DefaultData(DataObject.NULL_OBJ));
            return this;
        }

        public <V> Builder<T> addObj(String key, Class<V> type, Function<T, ? extends V> accessor) {
            this.accessors.put(key, accessor);
            this.defaults.put(key, new DefaultData(type, DataObject.NULL_OBJ));
            return this;
        }

        public <V> Builder<T> addList(String key, Function<T, List<V>> accessor) {
            this.accessors.put(key, accessor);
            this.defaults.put(key, new DefaultData(DataList.NULL_LIST));
            return this;
        }

        public <V> Builder<T> addList(String key, Class<V> type, Function<T, List<? extends V>> accessor) {
            this.accessors.put(key, accessor);
            this.defaults.put(key, new DefaultData(type, DataList.NULL_LIST));
            return this;
        }

        public DataSpec<T> build() {
            Objects.requireNonNull(this.constructor, "constructor");
            return new DataSpec(this);
        }
    }
}

