/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.concurrent;

import com.terraforged.core.concurrent.Resource;
import java.util.function.Consumer;

public class SimpleResource<T>
implements Resource<T> {
    private final T value;
    private final Consumer<T> closer;
    private long useCount = 0L;
    private boolean open = false;

    public SimpleResource(T value, Consumer<T> closer) {
        this.value = value;
        this.closer = closer;
    }

    @Override
    public T get() {
        this.open = true;
        ++this.useCount;
        return this.value;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            this.closer.accept(this.value);
        }
    }

    private void log() {
        if ((this.useCount & 0xFL) == 0L) {
            System.out.println(this.useCount);
        }
    }
}

