/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.concurrent.thread;

import com.terraforged.core.concurrent.thread.BatchingThreadPool;
import com.terraforged.core.concurrent.thread.ForkJoinThreadPool;
import com.terraforged.core.concurrent.thread.SingleThreadPool;
import com.terraforged.core.concurrent.thread.ThreadPool;
import java.lang.ref.WeakReference;

public class ThreadPools {
    private static final Object lock = new Object();
    private static final ThreadPool util = ThreadPools.createInitialPool(2);
    private static WeakReference<ThreadPool> instance = new WeakReference<Object>(null);

    public static ThreadPool getUtilPool() {
        return util;
    }

    private static ThreadPool createInitialPool(int poolSize) {
        if (poolSize == 1) {
            return new SingleThreadPool();
        }
        if (poolSize < 4) {
            return new ForkJoinThreadPool(poolSize, true);
        }
        return BatchingThreadPool.of(poolSize, true);
    }

    public static ThreadPool createDefault() {
        return ThreadPools.create(ThreadPools.defaultPoolSize());
    }

    public static ThreadPool create(int poolSize) {
        return ThreadPools.create(poolSize, poolSize < 4);
    }

    public static ThreadPool create(int poolSize, boolean batching) {
        return ThreadPools.create(poolSize, batching, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPool create(int poolSize, boolean batching, boolean keepAlive) {
        Object object = lock;
        synchronized (object) {
            ThreadPool current = (ThreadPool)instance.get();
            if (current != null && !current.keepAlive()) {
                if (poolSize == current.size() && current.supportsBatching() == batching) {
                    return current;
                }
                current.shutdown();
            }
        }
        if (poolSize == 1) {
            return ThreadPools.setAndGet(new SingleThreadPool());
        }
        if (poolSize < 4 || !batching) {
            return ThreadPools.setAndGet(new ForkJoinThreadPool(poolSize, keepAlive));
        }
        return ThreadPools.setAndGet(BatchingThreadPool.of(poolSize, keepAlive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadPool setAndGet(ThreadPool threadPool) {
        if (!threadPool.keepAlive()) {
            Object object = lock;
            synchronized (object) {
                instance = new WeakReference<ThreadPool>(threadPool);
            }
        }
        return threadPool;
    }

    public static int defaultPoolSize() {
        int processors = Runtime.getRuntime().availableProcessors();
        return Math.max(1, processors / 3 * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(ThreadPool threadPool) {
        Object object = lock;
        synchronized (object) {
            if (threadPool == instance.get()) {
                instance = new WeakReference<Object>(null);
            }
        }
    }
}

