/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.serialization.serializer;

import com.terraforged.core.serialization.annotation.Serializable;
import com.terraforged.core.serialization.serializer.Reader;
import com.terraforged.core.serialization.serializer.Serializer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class Deserializer {
    public static boolean deserialize(Reader reader, Object object) throws Throwable {
        boolean valid = true;
        Class<?> type = object.getClass();
        for (String name : reader.getKeys()) {
            if (name.charAt(0) == '#') continue;
            try {
                Field field = type.getField(name);
                if (!Serializer.isSerializable(field)) continue;
                field.setAccessible(true);
                valid &= Deserializer.fromValue(reader, object, field);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                valid = false;
            }
        }
        return valid;
    }

    private static boolean fromValue(Reader reader, Object object, Field field) throws Throwable {
        Class<?> type;
        if (field.getType() == Integer.TYPE) {
            field.set(object, reader.getInt(field.getName()));
            return true;
        }
        if (field.getType() == Float.TYPE) {
            field.set(object, Float.valueOf(reader.getFloat(field.getName())));
            return true;
        }
        if (field.getType() == Boolean.TYPE) {
            field.set(object, reader.getString(field.getName()).equals("true"));
            return true;
        }
        if (field.getType() == String.class) {
            field.set(object, reader.getString(field.getName()));
            return true;
        }
        if (field.getType().isEnum()) {
            String name = reader.getString(field.getName());
            for (Enum e : field.getType().asSubclass(Enum.class).getEnumConstants()) {
                if (!e.name().equals(name)) continue;
                field.set(object, e);
                return true;
            }
            return false;
        }
        if (field.getType().isAnnotationPresent(Serializable.class)) {
            Reader child = reader.getChild(field.getName());
            Object value = field.getType().newInstance();
            Deserializer.deserialize(child, value);
            field.set(object, value);
            return true;
        }
        if (field.getType().isArray() && (type = field.getType().getComponentType()).isAnnotationPresent(Serializable.class)) {
            Reader child = reader.getChild(field.getName());
            Object array = Array.newInstance(type, child.getSize());
            for (int i = 0; i < child.getSize(); ++i) {
                Object value = type.newInstance();
                Deserializer.deserialize(child.getChild(i), value);
                Array.set(array, i, value);
            }
            field.set(object, array);
        }
        return true;
    }
}

